/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceKBPermissions;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluencePermissionsAppLinkResponseHandler;
import io.atlassian.fugue.Either;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;

public class ConfluenceFullPermissionsAppLinkResponseHandler
extends ConfluencePermissionsAppLinkResponseHandler<ConfluenceKBPermissions> {
    public ConfluenceFullPermissionsAppLinkResponseHandler(String path, ErrorResultHelper errorResultHelper, ConfluenceKBErrors confluenceKbErrors, ApplicationLinkErrors applicationLinkErrors) {
        super(path, errorResultHelper, confluenceKbErrors, applicationLinkErrors);
    }

    public Either<AnError, ConfluenceKBPermissions> onSuccess(String responseBody) {
        if (responseBody == null) {
            log.debug("Response from the permissions endpoint of the Confluence knowledge base plugin was empty for path: {}", (Object)this.path);
            return Either.left((Object)this.applicationLinkErrors.GENERIC_COMMUNICATION_ERROR());
        }
        try {
            ConfluenceKBPermissions confluenceKbPermissionsResult = (ConfluenceKBPermissions)new ObjectMapper().readValue(responseBody, ConfluenceKBPermissions.class);
            return Either.right((Object)confluenceKbPermissionsResult);
        }
        catch (IOException | ClassCastException ex) {
            log.debug("Failed to complete operation for path {} with the following exception: {}", (Object)this.path, (Object)ex.getMessage());
            return Either.left((Object)this.applicationLinkErrors.GENERIC_COMMUNICATION_ERROR());
        }
    }
}

