/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseInternalService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.internal.api.request.KBCreateSpaceRequest;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseManager;
import com.atlassian.servicedesk.internal.rest.responses.kb.ConfluenceKBSpaceResponse;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
public class ConfluenceKnowledgeBaseServiceImpl
implements ConfluenceKnowledgeBaseService {
    private final ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseInternalService;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final UserFactory userFactory;
    private final ApplicationLinkErrors applicationLinkErrors;
    private final ConfluenceKnowledgeBaseManager confluenceKnowledgeBaseManager;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskService serviceDeskService;

    @Autowired
    public ConfluenceKnowledgeBaseServiceImpl(ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseInternalService, ServiceDeskAppLinkService serviceDeskAppLinkService, UserFactory userFactory, ApplicationLinkErrors applicationLinkErrors, ConfluenceKnowledgeBaseManager confluenceKnowledgeBaseManager, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskService serviceDeskService) {
        this.confluenceKnowledgeBaseInternalService = confluenceKnowledgeBaseInternalService;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.userFactory = userFactory;
        this.applicationLinkErrors = applicationLinkErrors;
        this.confluenceKnowledgeBaseManager = confluenceKnowledgeBaseManager;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskService = serviceDeskService;
    }

    public io.atlassian.fugue.Either<AnError, ConfluenceKnowledgeBaseLink> getKBLink(ApplicationUser user, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.confluenceKnowledgeBaseInternalService.getKBLink(checkedUser, project)).yield((checkedUser, kbLink) -> kbLink);
    }

    public io.atlassian.fugue.Either<AnError, ConfluenceKBSpaceResponse> createSpace(CheckedUser user, Project project, ApplicationLink applicationLink, KBCreateSpaceRequest request) {
        return Steps.begin(this.canCreateSpace(user, project)).then(isAdminAgent2 -> this.confluenceKnowledgeBaseManager.getKnowledgeBaseSpaceBlueprintId(applicationLink)).then((isAdminAgent2, blueprintId) -> this.confluenceKnowledgeBaseManager.createSpace(applicationLink, (String)blueprintId, request)).yield((isAdminAgent2, blueprintId, response) -> response);
    }

    public io.atlassian.fugue.Either<AnError, ConfluenceKnowledgeBaseLink> generateAndLinkSpace(CheckedUser user, Project project) {
        return Steps.begin(this.canCreateSpace(user, project)).then(isAdminAgent2 -> this.serviceDeskAppLinkService.getPrimaryApplicationLinkForType(ConfluenceApplicationType.class)).then((isAdminAgent2, primaryAppLink) -> this.confluenceKnowledgeBaseManager.getKnowledgeBaseSpaceBlueprintId((ApplicationLink)primaryAppLink)).then((isAdminAgent2, primaryAppLink, blueprintId) -> this.confluenceKnowledgeBaseManager.generateSpace(project, (ApplicationLink)primaryAppLink, (String)blueprintId)).then((isAdminAgent2, primaryAppLink, blueprintId, space) -> this.linkSpace(user, project, (ApplicationLink)primaryAppLink, (ConfluenceKBSpaceResponse)space)).yield((isAdminAgent2, primaryAppLink, blueprintId, space, linkedSpace) -> linkedSpace);
    }

    private io.atlassian.fugue.Either<AnError, ConfluenceKnowledgeBaseLink> linkSpace(CheckedUser user, Project project, ApplicationLink applicationLink, ConfluenceKBSpaceResponse space) {
        return this.confluenceKnowledgeBaseInternalService.updateKBLink(user, project, applicationLink.getId().get(), applicationLink.getRpcUrl().toString(), applicationLink.getName(), space.getKey(), space.getName(), space.getUrl());
    }

    private io.atlassian.fugue.Either<AnError, Boolean> canCreateSpace(CheckedUser user, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project))).then(serviceDesk -> StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user.forJIRA(), serviceDesk))).then((serviceDesk, isAdminAgent2) -> isAdminAgent2 != false ? io.atlassian.fugue.Either.right((Object)isAdminAgent2) : io.atlassian.fugue.Either.left((Object)this.applicationLinkErrors.APP_NO_PERMISSION())).yield((serviceDesk, isAdminAgent2, permission) -> permission);
    }
}

