/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkManager;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.request.ConfluenceKBCreateSpaceRequest;
import com.atlassian.servicedesk.internal.api.request.KBCreateSpaceRequest;
import com.atlassian.servicedesk.internal.applink.GenericAppLinkResponseHandlerFactory;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseLinkImpl;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseManager;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.enabled.ConfluenceKBEnabledQStore;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.kblink.ConfluenceKBLinkQStore;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.labels.ConfluenceKBLabelQStore;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.responses.ConfluenceKBCreateSpaceResponseHandler;
import com.atlassian.servicedesk.internal.rest.responses.kb.ConfluenceKBSpaceResponse;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ConfluenceKnowledgeBaseManagerImpl
implements ConfluenceKnowledgeBaseManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceKnowledgeBaseManagerImpl.class);
    private final ConfluenceKBLinkQStore confluenceKBLinkQStore;
    private final ConfluenceKBEnabledQStore confluenceKBEnabledQStore;
    private final ConfluenceKBLabelQStore confluenceKBLabelQStore;
    private final ConfluenceKBErrors kbErrors;
    private final ApplicationLinkErrors applicationLinkErrors;
    private final DatabaseAccessor databaseAccessor;
    private final ServiceDeskAppLinkManager serviceDeskAppLinkManager;
    private final GenericAppLinkResponseHandlerFactory genericAppLinkResponseHandlerFactory;
    private final ErrorResultHelper errorResultHelper;
    public static final int MAX_ATTEMPTS = 3;
    public static final int FIRST_ATTEMPT = 0;
    private static final String BLUEPRINT_KEY = "com.atlassian.confluence.plugins.confluence-knowledge-base:kb-blueprint";
    private static final String CREATE_SPACE_PATH = "/rest/create-dialog/1.0/space-blueprint/create-space";
    private static final String GET_SPACE_DETAILS_BY_KEY_PATH = "/rest/create-dialog/1.0/space-blueprint/byKey/%s";

    @Autowired
    public ConfluenceKnowledgeBaseManagerImpl(ConfluenceKBLinkQStore confluenceKBLinkQStore, ConfluenceKBEnabledQStore confluenceKBEnabledQStore, ConfluenceKBLabelQStore confluenceKBLabelQStore, ConfluenceKBErrors kbErrors, ApplicationLinkErrors applicationLinkErrors, DatabaseAccessor databaseAccessor, ServiceDeskAppLinkManager serviceDeskAppLinkManager, GenericAppLinkResponseHandlerFactory genericAppLinkResponseHandlerFactory, ErrorResultHelper errorResultHelper) {
        this.confluenceKBLinkQStore = confluenceKBLinkQStore;
        this.confluenceKBEnabledQStore = confluenceKBEnabledQStore;
        this.confluenceKBLabelQStore = confluenceKBLabelQStore;
        this.kbErrors = kbErrors;
        this.applicationLinkErrors = applicationLinkErrors;
        this.databaseAccessor = databaseAccessor;
        this.serviceDeskAppLinkManager = serviceDeskAppLinkManager;
        this.genericAppLinkResponseHandlerFactory = genericAppLinkResponseHandlerFactory;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public Either<AnError, ConfluenceKnowledgeBaseLink> addOrEditKBLink(ConfluenceKnowledgeBaseLink details, ServiceDesk serviceDesk) {
        return (Either)this.getKBLink(serviceDesk).fold(err -> this.addKBLink(details), kbLink -> this.editKBLink(new ConfluenceKnowledgeBaseLinkImpl(kbLink.getId(), details)));
    }

    @Override
    public Either<AnError, ConfluenceKnowledgeBaseLink> addKBLink(ConfluenceKnowledgeBaseLink confluenceAppLinkDetails) {
        return this.confluenceKBLinkQStore.addKBLink(confluenceAppLinkDetails).toRight(this.kbErrors::CONFLUENCE_KB_LINK_GENERIC_DB_ERROR);
    }

    @Override
    public Either<AnError, ConfluenceKnowledgeBaseLink> editKBLink(ConfluenceKnowledgeBaseLink confluenceAppLinkDetails) {
        return this.confluenceKBLinkQStore.updateKBLink(confluenceAppLinkDetails).toRight(this.kbErrors::CONFLUENCE_KB_LINK_GENERIC_DB_ERROR);
    }

    @Override
    public Either<AnError, ConfluenceKnowledgeBaseLink> getKBLink(ServiceDesk serviceDesk) {
        return this.confluenceKBLinkQStore.getKBLinkForServiceDesk(serviceDesk.getId()).toRight(this.kbErrors::CONFLUENCE_KB_LINK_GENERIC_DB_ERROR);
    }

    @Override
    public List<ConfluenceKnowledgeBaseLink> getAllKbLinks() {
        return this.confluenceKBLinkQStore.getAllKbLinks();
    }

    @Override
    public Either<AnError, JSDSuccess> deleteKBLink(ServiceDesk serviceDesk) {
        return (Either)this.databaseAccessor.runInTransaction(conn -> (Either)this.confluenceKBLinkQStore.getKBLinkForServiceDesk(serviceDesk.getId()).fold(() -> Either.right((Object)((Object)JSDSuccess.success())), kbLink -> {
            this.confluenceKBEnabledQStore.deleteKBEnabled((ConfluenceKnowledgeBaseLink)kbLink, (DatabaseConnection)conn);
            this.confluenceKBLabelQStore.deleteKBLabels((ConfluenceKnowledgeBaseLink)kbLink, (DatabaseConnection)conn);
            this.confluenceKBLinkQStore.deleteKBLink(serviceDesk.getId(), (DatabaseConnection)conn);
            return Either.right((Object)((Object)JSDSuccess.success()));
        }));
    }

    @Override
    public List<ConfluenceKnowledgeBaseLink> getKbLinkOfServiceDesks(List<ServiceDesk> sdList) {
        return this.confluenceKBLinkQStore.getKBLinkOfServiceDesks(Lists.transform(sdList, ServiceDesk::getId));
    }

    @Override
    public List<ConfluenceKnowledgeBaseLink> getKbLinkBasedOnAppLinkIdAndServiceDesks(String appLinkId, List<ServiceDesk> sdList) {
        return this.confluenceKBLinkQStore.getKbLinkBasedOnAppLinkIdAndServiceDeskIds(appLinkId, Lists.transform(sdList, ServiceDesk::getId));
    }

    @Override
    public List<ConfluenceKnowledgeBaseLink> getKbLinksBasedOnAppLinkId(String appLinkId) {
        return this.confluenceKBLinkQStore.getKbLinksBasedOnApplicationLinkId(appLinkId);
    }

    @Override
    @Nonnull
    public List<ConfluenceKnowledgeBaseLink> getKBLinksBySpaceKey(String spaceKey) {
        return this.confluenceKBLinkQStore.getKBLinksBySpaceKey(spaceKey);
    }

    @Override
    public Either<AnError, String> getKnowledgeBaseSpaceBlueprintId(ApplicationLink applicationLink) {
        String path = String.format(GET_SPACE_DETAILS_BY_KEY_PATH, BLUEPRINT_KEY);
        return (Either)this.serviceDeskAppLinkManager.makeGetRequest(applicationLink.getId().get(), path, (BaseAppLinkResponseHandler)this.genericAppLinkResponseHandlerFactory.createHandler()).fold(error -> Either.left((Object)this.applicationLinkErrors.CREATE_SPACE_ERROR()), this::getBlueprintIDFromResponse);
    }

    @Override
    public Either<AnError, ConfluenceKBSpaceResponse> createSpace(ApplicationLink applicationLink, String blueprintId, KBCreateSpaceRequest request) {
        return this.serviceDeskAppLinkManager.makePostRequest(applicationLink.getId().get(), CREATE_SPACE_PATH, (Object)new ConfluenceKBCreateSpaceRequest((String)request.getSpaceKey().getOrElse((Object)""), (String)request.getSpaceName().getOrElse((Object)""), blueprintId), (BaseAppLinkResponseHandler)new ConfluenceKBCreateSpaceResponseHandler(this.applicationLinkErrors, this.errorResultHelper));
    }

    @Override
    public Either<AnError, ConfluenceKBSpaceResponse> generateSpace(Project project, ApplicationLink applicationLink, String blueprintId) {
        return this.tryCreateSpaceMultipleTimes(project, applicationLink.getId().get(), blueprintId, project.getName(), project.getKey(), 0);
    }

    protected Either<AnError, ConfluenceKBSpaceResponse> tryCreateSpaceMultipleTimes(Project project, String applicationLinkId, String blueprintId, String spaceName, String spaceKey, int currentAttemptNumber) {
        if (currentAttemptNumber == 3) {
            logger.debug("Reached the maximum number of failed attempts to generate and link a space to project '{}'.", (Object)spaceKey);
            return Either.left((Object)this.applicationLinkErrors.GENERATED_SPACE_KEY_ALREADY_EXISTS(project.getKey()));
        }
        String newSpaceKey = spaceKey;
        if (currentAttemptNumber > 0) {
            newSpaceKey = newSpaceKey + currentAttemptNumber;
        }
        ConfluenceKBCreateSpaceRequest request = new ConfluenceKBCreateSpaceRequest(newSpaceKey, spaceName, blueprintId);
        int nextAttemptNumber = currentAttemptNumber + 1;
        return this.serviceDeskAppLinkManager.makePostRequest(applicationLinkId, CREATE_SPACE_PATH, (Object)request, (BaseAppLinkResponseHandler)new ConfluenceKBCreateSpaceResponseHandler(this.applicationLinkErrors, this.errorResultHelper)).left().flatMap(error -> {
            ErrorCode errorCode = (ErrorCode)error.getErrorCode().getOrNull();
            if (errorCode != null && errorCode.getErrorCode().equals("DUPLICATE:SPACE")) {
                return this.tryCreateSpaceMultipleTimes(project, applicationLinkId, blueprintId, spaceName, spaceKey, nextAttemptNumber);
            }
            return Either.left((Object)error);
        });
    }

    private Either<AnError, String> getBlueprintIDFromResponse(JsonNode response) {
        return this.getStringValue(response.get("id")).toRight(() -> {
            logger.error("Blueprint ID is missing from the Confluence response.");
            return this.applicationLinkErrors.GENERIC_COMMUNICATION_ERROR();
        });
    }

    private Option<String> getStringValue(JsonNode jsonNode) {
        return Option.option((Object)jsonNode).map(JsonNode::getTextValue);
    }
}

