/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.util.runners.AuthenticationContextUtil;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.event.ServiceDeskCommentEvent;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.comment.InternalSDCommentManager;
import com.atlassian.servicedesk.internal.comment.SDComment;
import com.atlassian.servicedesk.internal.comment.ServiceDeskCommentUtil;
import com.atlassian.servicedesk.internal.comment.event.ServiceDeskCommentEventImpl;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import io.atlassian.fugue.Option;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskCommentEventPublisher {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final EventPublisher eventPublisher;
    private final SafeRunner safeRunner;
    private final UserFactory userFactory;
    private final AuthenticationContextUtil authenticationContextUtil;
    private final InternalSDCommentManager internalSDCommentManager;

    @Autowired
    public ServiceDeskCommentEventPublisher(JiraAuthenticationContext jiraAuthenticationContext, EventPublisher eventPublisher, SafeRunner safeRunner, UserFactory userFactory, AuthenticationContextUtil authenticationContextUtil, InternalSDCommentManager internalSDCommentManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.eventPublisher = eventPublisher;
        this.safeRunner = safeRunner;
        this.userFactory = userFactory;
        this.authenticationContextUtil = authenticationContextUtil;
        this.internalSDCommentManager = internalSDCommentManager;
    }

    public void onIssueChangedEvent(IssueChangedEvent event) {
        Date eventTime = ServiceDeskCommentEventPublisher.toNonnullDateOrNow(event.getTime());
        this.safeRunner.run(() -> event.getComment().ifPresent(comment -> this.publishServiceDeskCommentEvent((Comment)comment, true, eventTime)));
    }

    public void onCommentCreatedEvent(CommentCreatedEvent event) {
        Date eventTime = ServiceDeskCommentEventPublisher.toNonnullDateOrNow(event.getComment().getCreated());
        this.safeRunner.run(() -> this.publishServiceDeskCommentEvent(event.getComment(), true, eventTime));
    }

    public void onCommentUpdatedEvent(CommentUpdatedEvent event) {
        Date eventTime = ServiceDeskCommentEventPublisher.toNonnullDateOrNow(event.getComment().getUpdated());
        this.safeRunner.run(() -> this.publishServiceDeskCommentEvent(event.getComment(), false, eventTime));
    }

    private static Date toNonnullDateOrNow(Date nullableDate) {
        return (Date)Option.option((Object)nullableDate).getOr(Date::new);
    }

    private void publishServiceDeskCommentEvent(Comment comment, boolean isCreatedEvent, Date eventTime) {
        this.retrieveUserFromComment(comment, isCreatedEvent).forEach(checkedUser -> this.publishServiceDeskCommentEvent(comment, (CheckedUser)checkedUser, isCreatedEvent, eventTime));
    }

    private void publishServiceDeskCommentEvent(Comment comment, CheckedUser author, boolean isCreatedEvent, Date eventTime) {
        io.atlassian.fugue.Either<AnError, SDComment> sdCommentForComment = this.internalSDCommentManager.getSDCommentForComment(comment);
        sdCommentForComment.forEach(sdComment -> {
            ServiceDeskComment serviceDeskComment = ServiceDeskCommentUtil.convertToServiceDeskCommentWithoutAttachments(sdComment);
            ServiceDeskCommentEventImpl commentEvent = new ServiceDeskCommentEventImpl(author, comment.getIssue(), serviceDeskComment, isCreatedEvent, eventTime);
            this.publishWithinAuthenticationContext(commentEvent);
        });
    }

    private io.atlassian.fugue.Either<AnError, CheckedUser> retrieveUserFromComment(Comment comment, boolean isCreatedEvent) {
        if (isCreatedEvent) {
            return StepsConverters.newerEither((Either)this.userFactory.wrap(comment.getAuthorApplicationUser()));
        }
        return StepsConverters.newerEither((Either)this.userFactory.wrap(comment.getUpdateAuthorApplicationUser()));
    }

    private void publishWithinAuthenticationContext(ServiceDeskCommentEvent event) {
        if (this.jiraAuthenticationContext.getLoggedInUser() != null) {
            this.eventPublisher.publish((Object)event);
        } else {
            this.authenticationContextUtil.runAs(event.getUser(), () -> this.eventPublisher.publish((Object)event));
        }
    }
}

