/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.step.StepsConverters;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskCommentPropertyService {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDeskCommentPropertyService.class);
    private static final String SERVICE_DESK_COMMENT_PROPERTY = "sd.comment.property";
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final CommentPropertyService commentPropertyService;

    @Autowired
    public ServiceDeskCommentPropertyService(JsonEntityPropertyManager jsonEntityPropertyManager, CommentPropertyService commentPropertyService) {
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.commentPropertyService = commentPropertyService;
    }

    public void setSDCommentProperty(ApplicationUser applicationUser, Comment comment, String key, JSONObject value) {
        this.jsonEntityPropertyManager.put(applicationUser, SERVICE_DESK_COMMENT_PROPERTY, comment.getId(), key, value.toString(), (BiFunction)null, false);
    }

    public Option<JSONObject> getJIRACommentProperty(ApplicationUser applicationUser, Comment comment, String key) {
        EntityPropertyService.PropertyResult result = this.commentPropertyService.getProperty(applicationUser, comment.getId(), key);
        return this.convertPropertyToJSONObject((Option<EntityProperty>)StepsConverters.newerOption((com.atlassian.fugue.Option)result.getEntityProperty()), key);
    }

    public Option<JSONObject> getSDCommentProperty(Comment comment, String key) {
        Option result = Option.option((Object)this.jsonEntityPropertyManager.get(SERVICE_DESK_COMMENT_PROPERTY, comment.getId(), key));
        return this.convertPropertyToJSONObject((Option<EntityProperty>)result, key);
    }

    private Option<JSONObject> convertPropertyToJSONObject(Option<EntityProperty> result, String key) {
        return result.flatMap(property -> this.convertToJSON(key, property.getValue()));
    }

    private Option<JSONObject> convertToJSON(String key, String valueRaw) {
        if (StringUtils.isNotBlank((String)valueRaw)) {
            try {
                return Option.some((Object)new JSONObject(valueRaw));
            }
            catch (JSONException e) {
                LOG.warn("Comment property for " + key + " is corrupt and not valid JSON");
            }
        }
        return Option.none();
    }
}

