/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentCreateParameters;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ServiceDeskCommentCreateParametersImpl
implements ServiceDeskCommentCreateParameters {
    private final ApplicationUser author;
    private final Issue issue;
    private final Optional<String> body;
    final List<TemporaryAttachmentId> temporaryAttachmentIds;
    private final boolean _public;

    private ServiceDeskCommentCreateParametersImpl(ApplicationUser author, Issue issue, String body, Iterable<TemporaryAttachmentId> temporaryAttachmentIds, boolean _public) {
        this.author = (ApplicationUser)Preconditions.checkNotNull((Object)author);
        this.issue = (Issue)Preconditions.checkNotNull((Object)issue);
        this.body = Optional.ofNullable(body);
        this.temporaryAttachmentIds = ImmutableList.copyOf(temporaryAttachmentIds);
        this._public = _public;
    }

    @Nonnull
    public ApplicationUser author() {
        return this.author;
    }

    @Nonnull
    public Issue issue() {
        return this.issue;
    }

    public Optional<String> body() {
        return this.body;
    }

    public List<TemporaryAttachmentId> temporaryAttachmentIds() {
        return this.temporaryAttachmentIds;
    }

    public boolean publicComment() {
        return this._public;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDeskCommentCreateParametersImpl that = (ServiceDeskCommentCreateParametersImpl)o;
        return Objects.equals(this.author, that.author) && Objects.equals(this.issue, that.issue) && Objects.equals(this.body, that.body) && Objects.equals(this.temporaryAttachmentIds, that.temporaryAttachmentIds) && Objects.equals(this._public, that._public);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.issue, this.body, this.temporaryAttachmentIds, this._public);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("author", (Object)this.author).add("issue", (Object)this.issue).add("body", this.body).add("temporaryAttachmentIds", this.temporaryAttachmentIds).add("_public", this._public).toString();
    }

    private static final class Builder
    implements ServiceDeskCommentCreateParameters.Builder {
        private ApplicationUser author;
        private Issue issue;
        private String body;
        private List<TemporaryAttachmentId> temporaryAttachmentIds = Lists.newArrayList();
        private boolean _public;

        private Builder() {
        }

        public Builder author(ApplicationUser author) {
            this.author = author;
            return this;
        }

        public Builder issue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder temporaryAttachmentIds(List<TemporaryAttachmentId> temporaryAttachmentIds) {
            this.temporaryAttachmentIds = temporaryAttachmentIds;
            return this;
        }

        public Builder addTemporaryAttachmentId(TemporaryAttachmentId temporaryAttachmentId) {
            this.temporaryAttachmentIds.add(temporaryAttachmentId);
            return this;
        }

        public Builder addTemporaryAttachmentIds(Iterable<TemporaryAttachmentId> temporaryAttachmentIds) {
            for (TemporaryAttachmentId temporaryAttachmentId : temporaryAttachmentIds) {
                this.addTemporaryAttachmentId(temporaryAttachmentId);
            }
            return this;
        }

        public Builder publicComment(boolean _public) {
            this._public = _public;
            return this;
        }

        public ServiceDeskCommentCreateParametersImpl build() {
            if (this.body == null && this.temporaryAttachmentIds.isEmpty()) {
                Assertions.notNull((String)"body", (Object)this.body);
            }
            return new ServiceDeskCommentCreateParametersImpl(this.author, this.issue, this.body, this.temporaryAttachmentIds, this._public);
        }
    }
}

