/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.servicedesk.api.comment.CreateInternalCommentParameters;
import com.atlassian.servicedesk.api.comment.CreatePublicCommentParameters;
import com.atlassian.servicedesk.internal.comment.SDCommentCreateVisibility;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class SDCommentCreateParameters {
    private final ApplicationUser author;
    private final Issue issue;
    private final String commentBody;
    private final String groupLevel;
    private final Long roleLevelId;
    private final Date created;
    private final SDCommentCreateVisibility visibility;
    @TenantAware(value=TenancyScope.TENANTED)
    private final Map<String, JSONObject> commentProperties;

    private SDCommentCreateParameters(ApplicationUser author, Issue issue, String commentBody, @Nullable String groupLevel, @Nullable Long roleLevelId, @Nullable Date created, SDCommentCreateVisibility visibility, Map<String, JSONObject> commentProperties) {
        this.author = author;
        this.issue = issue;
        this.commentBody = commentBody;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.created = created;
        this.visibility = visibility;
        this.commentProperties = commentProperties;
    }

    public static Builder createNew() {
        return new Builder();
    }

    public ApplicationUser getAuthor() {
        return this.author;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public String getCommentBody() {
        return this.commentBody;
    }

    @Nullable
    public String getGroupLevel() {
        return this.groupLevel;
    }

    @Nullable
    public Long getRoleLevelId() {
        return this.roleLevelId;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    public SDCommentCreateVisibility getVisibility() {
        return this.visibility;
    }

    public Map<String, JSONObject> getCommentProperties() {
        return this.commentProperties;
    }

    @ParametersAreNonnullByDefault
    @ReturnValuesAreNonnullByDefault
    public static final class Builder {
        private ApplicationUser author;
        private Issue issue;
        private String commentBody;
        private String groupLevel;
        private Long roleLevelId;
        private Date created;
        private SDCommentCreateVisibility visibility;
        private Map<String, JSONObject> commentProperties;

        public Builder withAuthor(ApplicationUser author) {
            this.author = author;
            return this;
        }

        public Builder withIssue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public Builder withCommentBody(String commentBody) {
            this.commentBody = commentBody;
            return this;
        }

        public Builder withGroupLevel(@Nullable String groupLevel) {
            this.groupLevel = groupLevel;
            return this;
        }

        public Builder withRoleLevelId(@Nullable Long roleLevelId) {
            this.roleLevelId = roleLevelId;
            return this;
        }

        public Builder withCreated(@Nullable Date created) {
            this.created = created;
            return this;
        }

        public Builder withVisibility(SDCommentCreateVisibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder withCommentProperties(Map<String, JSONObject> commentProperties) {
            this.commentProperties = commentProperties;
            return this;
        }

        public Builder fromPublicCommentParameters(CreatePublicCommentParameters parameters) {
            this.author = parameters.getAuthor();
            this.issue = parameters.getIssue();
            this.commentBody = parameters.getBody();
            this.groupLevel = parameters.getGroupLevel();
            this.roleLevelId = parameters.getRoleLevelId();
            this.created = parameters.getCreated();
            this.visibility = SDCommentCreateVisibility.FORCE_PUBLIC;
            this.commentProperties = parameters.getCommentProperties();
            return this;
        }

        public Builder fromInternalCommentParameters(CreateInternalCommentParameters parameters) {
            this.author = parameters.getAuthor();
            this.issue = parameters.getIssue();
            this.commentBody = parameters.getBody();
            this.groupLevel = parameters.getGroupLevel();
            this.roleLevelId = parameters.getRoleLevelId();
            this.created = parameters.getCreated();
            this.visibility = SDCommentCreateVisibility.FORCE_INTERNAL;
            this.commentProperties = parameters.getCommentProperties();
            return this;
        }

        public SDCommentCreateParameters andBuild() {
            return new SDCommentCreateParameters(this.author, this.issue, this.commentBody, this.groupLevel, this.roleLevelId, this.created, this.visibility, this.commentProperties);
        }
    }
}

