/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public final class JiraCommentAndAttachments {
    private final Comment comment;
    private final List<Attachment> attachments;

    private JiraCommentAndAttachments(Comment comment, List<Attachment> attachments) {
        this.comment = comment;
        this.attachments = ImmutableList.copyOf(attachments);
    }

    public Comment getComment() {
        return this.comment;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public boolean hasAttachments() {
        return !this.attachments.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ParametersAreNonnullByDefault
    public static class Builder {
        private Option<Comment> commentOption = Option.none();
        private Option<List<Attachment>> attachmentsOption = Option.none();

        private Builder() {
        }

        public Builder comment(Comment comment) {
            this.commentOption = Option.some((Object)comment);
            return this;
        }

        public Builder attachments(List<Attachment> attachments) {
            this.attachmentsOption = Option.some(attachments);
            return this;
        }

        public JiraCommentAndAttachments build() {
            return new JiraCommentAndAttachments((Comment)this.commentOption.getOrThrow(() -> new RuntimeException("This expects a comment, but none provided")), (List)this.attachmentsOption.getOrElse(Collections.emptyList()));
        }
    }
}

