/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.comment.InternalSDCommentManager;
import com.atlassian.servicedesk.internal.comment.SDComment;
import com.atlassian.servicedesk.internal.comment.ServiceDeskCommentPropertyService;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalSDCommentManagerImpl
implements InternalSDCommentManager {
    private static final Logger LOG = LoggerFactory.getLogger(InternalSDCommentManagerImpl.class);
    private final ServiceDeskCommentPropertyService serviceDeskCommentPropertyService;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final CommonErrors commonErrors;

    @Autowired
    public InternalSDCommentManagerImpl(ServiceDeskCommentPropertyService serviceDeskCommentPropertyService, ServiceDeskInternalManager serviceDeskInternalManager, CommonErrors commonErrors) {
        this.serviceDeskCommentPropertyService = serviceDeskCommentPropertyService;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.commonErrors = commonErrors;
    }

    @Override
    public boolean isCommentInternal(Comment comment) {
        if (comment.getAuthorApplicationUser() == null) {
            return true;
        }
        Option<JSONObject> commentPropertyOpt = this.serviceDeskCommentPropertyService.getSDCommentProperty(comment, "sd.public.comment");
        return this.checkProperty(commentPropertyOpt, "internal");
    }

    @Override
    public boolean isCommentInternalInJIRA(ApplicationUser user, Comment comment) {
        Option<JSONObject> commentPropertyOpt = this.serviceDeskCommentPropertyService.getJIRACommentProperty(user, comment, "sd.public.comment");
        return this.checkProperty(commentPropertyOpt, "internal");
    }

    @Override
    public boolean isCommentAllowedToBePublic(ApplicationUser user, Comment comment) {
        Option<JSONObject> commentPropertyOpt = this.serviceDeskCommentPropertyService.getJIRACommentProperty(user, comment, "sd.allow.public.comment");
        return this.checkProperty(commentPropertyOpt, "allow");
    }

    @Override
    public boolean isCommentMadeByReporter(Issue issue, Comment comment) {
        return Option.option((Object)comment.getAuthorApplicationUser()).exists(author -> Objects.equals(author.getKey(), issue.getReporterId()));
    }

    @Override
    public boolean isCommentVisibleInPortal(ApplicationUser user, Comment comment) {
        if (user == null) {
            return false;
        }
        return !this.isCommentInternalInJIRA(user, comment) && !this.isCommentInternal(comment);
    }

    @Override
    public Either<AnError, SDComment> getSDCommentForComment(Comment comment) {
        if (!this.isCommentOfServiceDeskProject(comment)) {
            return Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        return Either.right((Object)this.convertToSDComment(comment));
    }

    @Override
    public Either<AnError, List<SDComment>> getSDCommentForCommentsOfIssue(Issue issue, List<Comment> comment) {
        if (!this.isIssueOfServiceDeskProject(issue)) {
            return Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        List sdComments = comment.stream().map(this::convertToSDComment).collect(Collectors.toList());
        return Either.right(sdComments);
    }

    @Override
    public Map<String, JSONObject> retrieveNonPublicCommentProperty() {
        HashMap<String, JSONObject> propertyMap = new HashMap<String, JSONObject>();
        propertyMap.put("sd.public.comment", this.retrieveNonPublicCommentPropertyValue());
        return propertyMap;
    }

    @Override
    public JSONObject retrieveNonPublicCommentPropertyValue() {
        HashMap<String, Boolean> nonPublicCommentPropertyValue = new HashMap<String, Boolean>();
        nonPublicCommentPropertyValue.put("internal", true);
        return new JSONObject(nonPublicCommentPropertyValue);
    }

    @Override
    public Map<String, JSONObject> retrieveAllowPublicCommentProperty() {
        HashMap<String, JSONObject> propertyMap = new HashMap<String, JSONObject>();
        propertyMap.put("sd.allow.public.comment", this.retrieveAllowPublicCommentPropertyValue());
        return propertyMap;
    }

    @Override
    public String[] retrieveAllowPublicCommentPropertyForTransitions() {
        try {
            JSONArray arr = new JSONArray();
            JSONObject obj = new JSONObject();
            arr.put((Object)obj);
            obj.put("key", (Object)"sd.allow.public.comment");
            JSONObject valueValue = new JSONObject();
            valueValue.put("allow", true);
            obj.put("value", (Object)valueValue);
            return new String[]{arr.toString()};
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private JSONObject retrieveAllowPublicCommentPropertyValue() {
        HashMap<String, Boolean> nonPublicCommentPropertyValue = new HashMap<String, Boolean>();
        nonPublicCommentPropertyValue.put("allow", true);
        return new JSONObject(nonPublicCommentPropertyValue);
    }

    @Override
    public boolean isNonPublicCommentProperty(JSONObject jsonObject) {
        try {
            return jsonObject.has("internal") && jsonObject.getBoolean("internal");
        }
        catch (JSONException e) {
            LOG.warn("The property {} in the given JSONObject {} is not a boolean", (Object)"internal", (Object)jsonObject);
            return true;
        }
    }

    private boolean checkProperty(Option<JSONObject> property, String propertyName) {
        return property.exists(commentProperty -> {
            if (commentProperty.has(propertyName)) {
                try {
                    return commentProperty.getBoolean(propertyName);
                }
                catch (JSONException e) {
                    LOG.warn("The property {} in the given JSONObject {} is not a boolean", (Object)propertyName, commentProperty);
                }
            }
            return false;
        });
    }

    private SDComment convertToSDComment(Comment comment) {
        boolean internal = this.isCommentInternal(comment);
        return new SDComment(comment, !internal);
    }

    private boolean isCommentOfServiceDeskProject(Comment comment) {
        return Option.option((Object)comment.getIssue()).exists(this::isIssueOfServiceDeskProject);
    }

    private boolean isIssueOfServiceDeskProject(Issue issue) {
        return Option.option((Object)issue.getProjectObject()).exists(this.serviceDeskInternalManager::isServiceDeskEnabled);
    }
}

