/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.comment.InternalJiraCommentService;
import io.atlassian.fugue.Either;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class InternalJiraCommentServiceImpl
implements InternalJiraCommentService {
    private final CommentService commentService;

    @Autowired
    public InternalJiraCommentServiceImpl(CommentService commentService) {
        this.commentService = commentService;
    }

    @Override
    public Either<AnError, Either<ValidationErrors, Comment>> createJiraProjectComment(CheckedUser user, CommentService.CommentParameters commentParameters) {
        CommentService.CommentCreateValidationResult commentCreateValidationResult = this.commentService.validateCommentCreate(user.forJIRA(), commentParameters);
        if (commentCreateValidationResult.isValid()) {
            return Either.right((Object)Either.right((Object)this.commentService.create(user.forJIRA(), commentCreateValidationResult, true)));
        }
        return Either.right((Object)Either.left((Object)ValidationErrors.newBuilder((ErrorCollection)commentCreateValidationResult.getErrorCollection()).build()));
    }
}

