/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.capability;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.capability.Capability;
import com.atlassian.servicedesk.internal.capability.CapabilityQStore;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CapabilityQStoreImpl
implements CapabilityQStore {
    private DatabaseAccessor databaseAccessor;

    private static ConstructorExpression<Capability> MAPPER() {
        return Projections.constructor(Capability.class, (Expression[])new Expression[]{Tables.CAPABILITY.ID, Tables.CAPABILITY.CAPABILITY_NAME, Tables.CAPABILITY.CAPABILITY_VALUE, Tables.CAPABILITY.USER_KEY});
    }

    @Autowired
    public CapabilityQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public void deleteCapabilitiesForServiceDesk(ServiceDesk serviceDesk) {
        this.databaseAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.CAPABILITY).where((Predicate)Tables.CAPABILITY.SERVICE_DESK_ID.eq((Object)serviceDesk.getId())).execute());
    }

    @Override
    public Option<Capability> createCapabilityForServiceDesk(ServiceDesk serviceDesk, Capability capability) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> Option.option((Object)this.createCapabilityWithConnection(serviceDesk, capability, (DatabaseConnection)conn)).flatMap(capabilityId -> this.getCapabilityByIdWithConnection((int)capabilityId, (DatabaseConnection)conn)));
    }

    private Integer createCapabilityWithConnection(ServiceDesk serviceDesk, Capability capability, DatabaseConnection connection) {
        return (Integer)connection.insert((RelationalPath)Tables.CAPABILITY).set((Path)Tables.CAPABILITY.CAPABILITY_NAME, (Object)capability.getName()).set((Path)Tables.CAPABILITY.CAPABILITY_VALUE, (Object)capability.getValue()).set(Tables.CAPABILITY.SERVICE_DESK_ID, (Object)serviceDesk.getId()).set((Path)Tables.CAPABILITY.USER_KEY, capability.getUserKey().getOrNull()).executeWithKey(Tables.CAPABILITY.ID);
    }

    @Override
    public Option<Capability> getCapabilityById(int capabilityId) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> this.getCapabilityByIdWithConnection(capabilityId, (DatabaseConnection)conn));
    }

    private Option<Capability> getCapabilityByIdWithConnection(int capabilityId, DatabaseConnection connection) {
        return Option.option((Object)((SQLQuery)((SQLQuery)connection.select(CapabilityQStoreImpl.MAPPER()).from((Expression)Tables.CAPABILITY)).where((Predicate)Tables.CAPABILITY.ID.eq((Object)capabilityId))).fetchOne());
    }

    @Override
    public void deleteCapabilityById(int capabilityId) {
        this.databaseAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.CAPABILITY).where((Predicate)Tables.CAPABILITY.ID.eq((Object)capabilityId)).execute());
    }

    @Override
    public List<Capability> getCapabilitiesByServiceDesk(ServiceDesk serviceDesk) {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select(CapabilityQStoreImpl.MAPPER()).from((Expression)Tables.CAPABILITY)).where((Predicate)Tables.CAPABILITY.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()))).fetch());
    }

    @Override
    public Option<Capability> updateCapability(Capability capability, String capabilityValue) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> {
            this.updateCapabilityWithConnection(capability, capabilityValue, (DatabaseConnection)conn);
            return this.getCapabilityByIdWithConnection(capability.getId(), (DatabaseConnection)conn);
        });
    }

    private void updateCapabilityWithConnection(Capability capability, String capabilityValue, DatabaseConnection connection) {
        long rowsUpdated = connection.update((RelationalPath)Tables.CAPABILITY).set((Path)Tables.CAPABILITY.CAPABILITY_VALUE, (Object)capabilityValue).where((Predicate)Tables.CAPABILITY.ID.eq((Object)capability.getId())).execute();
        if (rowsUpdated != 1L) {
            throw new RuntimeException(String.format("Expected %d row of capability to be updated, but %d updated", 1, rowsUpdated));
        }
    }

    @Override
    public Option<Integer> getCapabilityServiceDeskId(int capabilityId) {
        return Option.option((Object)this.databaseAccessor.runInNewTransaction(conn -> (Integer)((SQLQuery)((SQLQuery)conn.select(Tables.CAPABILITY.SERVICE_DESK_ID).from((Expression)Tables.CAPABILITY)).where((Predicate)Tables.CAPABILITY.ID.eq((Object)capabilityId))).fetchOne()));
    }
}

