/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.capability;

import com.atlassian.pocketknife.api.ao.dao.AbstractModel;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;

public class Capability
extends AbstractModel {
    private final String name;
    private final String value;
    private final Option<String> userKey;

    public Capability(Integer id, String name, String value) {
        this(id, name, value, (Option<String>)Option.none());
    }

    public Capability(Integer id, String name, String value, String userKey) {
        super(id);
        this.name = name;
        this.value = value;
        this.userKey = Option.option((Object)userKey);
    }

    public Capability(Integer id, String name, String value, Option<String> userKey) {
        super(id);
        this.name = name;
        this.value = value;
        this.userKey = userKey;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Option<String> getUserKey() {
        return this.userKey;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("value", (Object)this.getValue()).add("userKey", this.getUserKey()).toString();
    }

    public static CapabilityBuilder builder() {
        return new CapabilityBuilder();
    }

    public static CapabilityBuilder builder(Capability capability) {
        return new CapabilityBuilder(capability);
    }

    public static class CapabilityBuilder {
        private Integer id;
        private String name;
        private String value;
        private Option<String> userKey;

        public CapabilityBuilder() {
            this.userKey((Option<String>)Option.none());
        }

        public CapabilityBuilder(Capability capability) {
            this.id(capability.getId());
            this.name(capability.getName());
            this.value(capability.getValue());
            this.userKey(capability.getUserKey());
        }

        public CapabilityBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public CapabilityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CapabilityBuilder value(String value) {
            this.value = value;
            return this;
        }

        public CapabilityBuilder userKey(Option<String> userKey) {
            this.userKey = userKey;
            return this;
        }

        public Capability build() {
            return new Capability(this.id, this.name, this.value, this.userKey);
        }
    }
}

