/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation.rulewhen;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.automation.rulewhen.SLAThresholdEventWhenHandlerHelper;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.WhenHandlerValidator;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;

public class SLAThresholdEventWhenHandlerValidator
implements WhenHandlerValidator {
    private final I18nHelper i18n;
    private final SLAThresholdEventWhenHandlerHelper slaThresholdEventWhenHandlerHelper;

    public SLAThresholdEventWhenHandlerValidator(I18nHelper i18n, SLAThresholdEventWhenHandlerHelper slaThresholdEventWhenHandlerHelper) {
        this.i18n = i18n;
        this.slaThresholdEventWhenHandlerHelper = slaThresholdEventWhenHandlerHelper;
    }

    public ValidationResult validate(@Nonnull WhenHandlerValidator.WhenHandlerValidationParam whenHandlerValidationParam) {
        ApplicationUser user = whenHandlerValidationParam.getUserToValidateWith();
        Option projectContext = StepsConverters.newerOption((com.atlassian.fugue.Option)whenHandlerValidationParam.getProjectContext());
        Option<Project> projectOpt = this.getProject((Option<ProjectContext>)projectContext);
        if (projectOpt.isEmpty()) {
            return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{this.i18n.getText("sd.sla.threshold.when.validation.failure.missing.project")}));
        }
        Project project = (Project)projectOpt.get();
        SLAThresholdEventWhenHandlerHelper.SLAThresholdHelperResult slaThresholdHelperResult = this.slaThresholdEventWhenHandlerHelper.validateSLAThresholdContext(user, project, whenHandlerValidationParam.getConfiguration().getData().getAll());
        if (slaThresholdHelperResult.getValidationErrors().isEmpty()) {
            return ValidationResult.PASSED();
        }
        return ValidationResult.FAILED(slaThresholdHelperResult.getValidationErrors());
    }

    private Option<Project> getProject(Option<ProjectContext> projectContextOpt) {
        for (ProjectContext context : projectContextOpt) {
            if (context.getProjects().size() != 1) continue;
            return Option.some(context.getProjects().get(0));
        }
        return Option.none();
    }
}

