/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation.rulewhen;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.search.issue.util.NumberUtil;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdService;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SLAThresholdEventWhenHandlerHelper {
    private final InternalTimeMetricService timeMetricService;
    private final InternalServiceDeskService serviceDeskService;
    private final UserFactory userFactory;
    private final SlaThresholdService slaThresholdService;
    private final I18nHelper i18n;

    @Autowired
    public SLAThresholdEventWhenHandlerHelper(I18nHelper i18n, InternalServiceDeskService serviceDeskService, InternalTimeMetricService timeMetricService, UserFactory userFactory, SlaThresholdService slaThresholdService) {
        this.i18n = i18n;
        this.serviceDeskService = serviceDeskService;
        this.timeMetricService = timeMetricService;
        this.userFactory = userFactory;
        this.slaThresholdService = slaThresholdService;
    }

    public SLAThresholdHelperResult validateSLAThresholdContext(ApplicationUser user, Project project, Map<String, String> data) {
        io.atlassian.fugue.Either serviceDeskEither = StepsConverters.newerEither((Either)this.userFactory.wrap(user)).flatMap(checkedUser -> this.serviceDeskService.getServiceDeskForProject(checkedUser, project, false));
        if (serviceDeskEither.isLeft()) {
            return this.failure(Lists.newArrayList((Object[])new String[]{((AnError)serviceDeskEither.left().get()).getMessage().getMessage()}));
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskEither.right().get();
        Option rawMetricIdOpt = Option.option((Object)data.get("metricId"));
        Option rawThresholdMillisOpt = Option.option((Object)data.get("thresholdTime"));
        if (rawMetricIdOpt.isEmpty() || rawThresholdMillisOpt.isEmpty()) {
            return this.failure(Lists.newArrayList((Object[])new String[]{this.i18n.getText("sd.sla.threshold.when.validation.failure.missing.configuration")}));
        }
        Option metricIdOpt = Option.option((Object)NumberUtil.toLong((String)((String)rawMetricIdOpt.get())));
        Option thresholdMillisOpt = Option.option((Object)NumberUtil.toLong((String)((String)rawThresholdMillisOpt.get())));
        if (metricIdOpt.isEmpty() || thresholdMillisOpt.isEmpty()) {
            return this.failure(Lists.newArrayList((Object[])new String[]{this.i18n.getText("sd.sla.threshold.when.validation.failure.corrupt.configuration")}));
        }
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetricEither = this.timeMetricService.getTimeMetric(user, serviceDesk, ((Long)metricIdOpt.get()).intValue());
        if (timeMetricEither.isLeft()) {
            return this.failure(Lists.newArrayList((Iterable)((ErrorCollection)timeMetricEither.left().get()).getErrorMessages()));
        }
        TimeMetric timeMetric = (TimeMetric)((Object)timeMetricEither.right().get());
        io.atlassian.fugue.Either<AnError, List<SlaThreshold>> thresholdsEither = this.slaThresholdService.getThresholds(user, timeMetric);
        if (thresholdsEither.isLeft()) {
            return this.failure(Lists.newArrayList((Object[])new String[]{((AnError)thresholdsEither.left().get()).getMessage().getMessage()}));
        }
        List thresholds = (List)thresholdsEither.right().get();
        for (SlaThreshold slaThreshold : thresholds) {
            if (!slaThreshold.getRemainingTime().equals(thresholdMillisOpt.get())) continue;
            return new SLAThresholdHelperResult(Collections.emptyList(), timeMetric, slaThreshold);
        }
        return this.failure(Lists.newArrayList((Object[])new String[]{this.i18n.getText("sd.sla.threshold.when.validation.failure.missing.threshold")}));
    }

    private SLAThresholdHelperResult failure(List<String> errorMessages2) {
        return new SLAThresholdHelperResult(errorMessages2, null, null);
    }

    public static class SLAThresholdHelperResult {
        private final List<String> validationErrors;
        private final TimeMetric timeMetric;
        private final SlaThreshold threshold;

        public SLAThresholdHelperResult(@Nonnull List<String> validationErrors, TimeMetric timeMetric, SlaThreshold threshold) {
            this.validationErrors = validationErrors;
            this.timeMetric = timeMetric;
            this.threshold = threshold;
        }

        @Nonnull
        public List<String> getValidationErrors() {
            return this.validationErrors;
        }

        @Nullable
        public TimeMetric getTimeMetric() {
            return this.timeMetric;
        }

        @Nullable
        public SlaThreshold getThreshold() {
            return this.threshold;
        }
    }
}

