/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation.rulewhen;

import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.automation.rulewhen.SLAThresholdEventWhenHandlerHelper;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.EventTimeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerProjectContextService;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerRunInContextService;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdExceeded;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdsExceededEvent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLAThresholdEventWhenHandler
implements EventWhenHandler<SlaThresholdsExceededEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(SLAThresholdEventWhenHandler.class);
    public static final String METRIC_ID_KEY = "metricId";
    public static final String THRESHOLD_MILLIS_KEY = "thresholdTime";
    public static final String PROJECT_KEY = "projectKey";
    private final I18nHelper i18n;
    private final SLAThresholdEventWhenHandlerHelper slaThresholdEventWhenHandlerHelper;
    private final EventTimeMessageHelper eventTimeMessageHelper;
    private final IssueMessageHelper issueMessageHelper;
    private final WhenHandlerProjectContextService whenHandlerProjectContextService;
    private final WhenHandlerRunInContextService whenHandlerRunInContextService;
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService;

    public SLAThresholdEventWhenHandler(I18nHelper i18n, SLAThresholdEventWhenHandlerHelper slaThresholdEventWhenHandlerHelper, WhenHandlerProjectContextService whenHandlerProjectContextService, IssueMessageHelper issueMessageHelper, EventTimeMessageHelper eventTimeMessageHelper, WhenHandlerRunInContextService whenHandlerRunInContextService, RuleMessageBuilderService ruleMessageBuilderService, RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService) {
        this.i18n = i18n;
        this.slaThresholdEventWhenHandlerHelper = slaThresholdEventWhenHandlerHelper;
        this.whenHandlerProjectContextService = whenHandlerProjectContextService;
        this.issueMessageHelper = issueMessageHelper;
        this.eventTimeMessageHelper = eventTimeMessageHelper;
        this.whenHandlerRunInContextService = whenHandlerRunInContextService;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.ruleExecutionCommandBuilderService = ruleExecutionCommandBuilderService;
    }

    public Class<SlaThresholdsExceededEvent> getEventClass() {
        return SlaThresholdsExceededEvent.class;
    }

    public List<RuleExecutionCommand> handleEvent(@Nonnull List<WhenHandlerContext> contexts, @Nonnull SlaThresholdsExceededEvent slaThresholdsExceededEvent) {
        RuleMessage message = this.createRuleMessage(slaThresholdsExceededEvent);
        ArrayList toReturn = Lists.newArrayList();
        for (WhenHandlerContext whenHandlerContext : contexts) {
            SLAThresholdEventWhenHandlerHelper.SLAThresholdHelperResult validationResult = this.validateWithHelper(whenHandlerContext);
            if (!validationResult.getValidationErrors().isEmpty()) continue;
            for (SlaThresholdExceeded exceeded : slaThresholdsExceededEvent.getThresholdsExceeded()) {
                for (SlaThreshold slaThreshold : exceeded.getThresholds()) {
                    if (!this.matchesEvent(validationResult, slaThreshold, exceeded.getTimeMetric().getId())) continue;
                    toReturn.add(this.createRuleExecutionCommand(whenHandlerContext, message));
                }
            }
        }
        LOG.debug("# of matched rule references: {0}", (Object)toReturn.size());
        return toReturn;
    }

    private RuleExecutionCommand createRuleExecutionCommand(WhenHandlerContext context, RuleMessage message) {
        RuleExecutionCommandBuilder builder = this.ruleExecutionCommandBuilderService.builder().ruleMessage(message).ruleReference(context.getRuleReference());
        return builder.build();
    }

    private RuleMessage createRuleMessage(SlaThresholdsExceededEvent event) {
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder();
        this.issueMessageHelper.setIssueData(builder, event.getIssue());
        this.eventTimeMessageHelper.setEventTime(builder, event.getTime());
        return builder.build();
    }

    private boolean matchesEvent(SLAThresholdEventWhenHandlerHelper.SLAThresholdHelperResult validationResult, SlaThreshold eventSLAThreshold, int eventMetricId) {
        SlaThreshold threshold = validationResult.getThreshold();
        TimeMetric timeMetric = validationResult.getTimeMetric();
        return threshold != null && timeMetric != null && threshold.getRemainingTime().equals(eventSLAThreshold.getRemainingTime()) && timeMetric.getId().equals(eventMetricId);
    }

    private SLAThresholdEventWhenHandlerHelper.SLAThresholdHelperResult validateWithHelper(WhenHandlerContext whenHandlerContext) {
        return (SLAThresholdEventWhenHandlerHelper.SLAThresholdHelperResult)this.whenHandlerRunInContextService.executeInContext(whenHandlerContext, applicationUser -> {
            io.atlassian.fugue.Option applicationProjectContext = StepsConverters.newerOption((Option)this.whenHandlerProjectContextService.getApplicationProjectContext(whenHandlerContext).right().toOption());
            for (ProjectContext pc : applicationProjectContext) {
                if (pc.getProjects().size() != 1) continue;
                return this.slaThresholdEventWhenHandlerHelper.validateSLAThresholdContext(applicationUser, (Project)pc.getProjects().get(0), whenHandlerContext.getWhenHandlerConfiguration().getData().getAll());
            }
            return new SLAThresholdEventWhenHandlerHelper.SLAThresholdHelperResult(Lists.newArrayList((Object[])new String[]{this.i18n.getText("sd.sla.threshold.when.validation.failure.missing.project")}), null, null);
        });
    }
}

