/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation.defaultrule;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.automation.defaultrule.DefaultAutomationRuleData;
import com.atlassian.servicedesk.internal.automation.defaultrule.DefaultAutomationRuleService;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.ProjectTemplateCustomFieldsManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSetService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputValidationService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidatedRuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationOutcome;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsSpecificUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.PermissionCheckFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlags;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAutomationRuleServiceImpl
implements DefaultAutomationRuleService {
    private static final String SERVICE_DESK_AUTOMATION_MODULES_PLUGIN_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin";
    private static final String ISSUE_COMMENTED_WHEN_HANDLER_MODULE_KEY = "servicedesk-commented-automation-rule-when-handler";
    private static final String ISSUE_COMMENTED_WHEN_HANDLER_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:servicedesk-commented-automation-rule-when-handler";
    private static final String SLA_TIME_REMAINING_WHEN_HANDLER_MODULE_KEY = "sla-threshold-when-handler";
    private static final String SLA_TIME_REMAINING_WHEN_HANDLER_COMPLETE_KEY = "com.atlassian.servicedesk:sla-threshold-when-handler";
    private static final String ISSUE_CREATED_WHEN_HANDLER_MODULE_KEY = "issue-created-automation-rule-when-handler";
    private static final String ISSUE_CREATED_WHEN_HANDLER_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-created-automation-rule-when-handler";
    private static final String WORKFLOW_TRANSITION_THEN_ACTION_MODULE_KEY = "workflow-transition-action";
    private static final String WORKFLOW_TRANSITION_THEN_ACTION_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:workflow-transition-action";
    private static final String JQL_IF_CONDITION_MODULE_KEY = "jql-if-condition";
    private static final String JQL_IF_CONDITION_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:jql-if-condition";
    private static final String COMMENT_VISIBILITY_MODULE_KEY = "sd-comment-visibility-if-condition";
    private static final String COMMENT_VISIBILITY_MODULE_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:sd-comment-visibility-if-condition";
    private static final String USER_TYPE_MODULE_KEY = "sd-user-role-if-condition";
    private static final String USER_TYPE_MODULE_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:sd-user-role-if-condition";
    private static final String INCIDENT_UPDATE_BLUEPRINT_MODULE_KEY = "sd-automation-incident-update-blueprint";
    private static final String INCIDENT_UPDATE_BLUEPRINT_MODULE_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:sd-automation-incident-update-blueprint";
    private static final String COMMENT_ACTION_MODULE_KEY = "servicedesk-comment-action";
    private static final String COMMENT_ACTION_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:servicedesk-comment-action";
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ErrorResultHelper errorResultHelper;
    private final ProjectTemplateCustomFieldsManager customFieldsManager;
    private final SearchService searchService;
    private final String NAME_TRANSITION_ON_COMMENT_KEY = "sd.automation.blueprint.comment.transition.name";
    private final String DESCRIPTION_KEY_TRANSITION_ON_COMMENT = "sd.automation.blueprint.comment.transition.description";
    private final String WAITING_FOR_SUPPORT_KEY = "sd.workflow.itsupport.v2.step.name.waiting.for.support";
    private final String WAITING_FOR_CUSTOMER_KEY = "sd.workflow.itsupport.v2.step.name.waiting.for.customer";
    private final String TO_SUPPORT_ACTION_KEY = "sd.workflow.itsupport.v2.transition.respond.to.support.name";
    private final String TO_CUSTOMER_ACTION_KEY = "sd.workflow.itsupport.v2.transition.respond.to.customer.name";
    private final String AUTO_CLOSE_RULE_NAME_KEY = "sd.project.template.itil.v2.automation.rule.auto.close.name";
    private final String AUTO_CLOSE_RULE_DESCRIPTION_KEY = "sd.project.template.itil.v2.automation.rule.auto.close.description";
    private final String AUTO_APPROVE_RULE_NAME_KEY = "sd.project.template.itil.v2.automation.rule.auto.approve.name";
    private final String AUTO_APPROVE_RULE_DESCRIPTION_KEY = "sd.project.template.itil.v2.automation.rule.auto.approve.description";
    private final String CLOSE_TRANSITION_KEY = "sd.workflow.close";
    private final String APPROVE_TRANSITION_KEY = "sd.workflow.approve";
    Logger logger = LoggerFactory.getLogger(DefaultAutomationRuleService.class);

    public DefaultAutomationRuleServiceImpl(VpOriginCustomFieldService vpOriginCustomFieldService, I18nHelper.BeanFactory i18nFactory, ErrorResultHelper errorResultHelper, ProjectTemplateCustomFieldsManager customFieldsManager, SearchService searchService) {
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.i18nFactory = i18nFactory;
        this.errorResultHelper = errorResultHelper;
        this.customFieldsManager = customFieldsManager;
        this.searchService = searchService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Long> createTransitionOnCommentRuleset(ApplicationUser user, Project project) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        I18nHelper serverI18n = this.i18nFactory.getInstance((ApplicationUser)null);
        DefaultAutomationRuleData ruleData = new DefaultAutomationRuleData(serverI18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.support"), serverI18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.customer"), serverI18n.getText("sd.workflow.itsupport.v2.transition.respond.to.customer.name"), serverI18n.getText("sd.workflow.itsupport.v2.transition.respond.to.support.name"));
        io.atlassian.fugue.Either<AnError, RuleSet> result = this.createTransitionOnCommentRulesetProper(user, project, i18n.getText("sd.automation.blueprint.comment.transition.name"), i18n.getText("sd.automation.blueprint.comment.transition.description"), ruleData, true);
        if (result.isLeft()) {
            this.logger.warn(((AnError)result.left().get()).getMessage().getMessage());
            return io.atlassian.fugue.Either.left((Object)result.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)((RuleSet)result.right().get()).getId());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Long> createUpdateOnLinkedIssueTransitionRuleset(ApplicationUser user, Project project) {
        ServiceFlags flags = ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{PermissionCheckFlag.SKIP_PERMISSION_CHECK});
        return StepsConverters.newerEither((Either)this.getRuleSetService().create(user, project, INCIDENT_UPDATE_BLUEPRINT_MODULE_COMPLETE_KEY, flags).map(RuleSet::getId));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Long> createAutoCloseAfterResolveRuleset(ApplicationUser user, Project project, TimeMetric timeMetric) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        I18nHelper serverI18n = this.i18nFactory.getInstance((ApplicationUser)null);
        RuleSetInputBuilder builder = this.getBuilderService().newRuleSetBuilder().name(i18n.getText("sd.project.template.itil.v2.automation.rule.auto.close.name")).description(i18n.getText("sd.project.template.itil.v2.automation.rule.auto.close.description")).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata();
        RuleSetInputBuilder.RuleBuilder ruleBuilder = builder.rule();
        ruleBuilder.when().whenHandler().moduleKey(SLA_TIME_REMAINING_WHEN_HANDLER_COMPLETE_KEY).data(this.getBuilderService().newConfigurationDataBuilder().put("metricId", timeMetric.getId().toString()).put("thresholdTime", "0").build()).endWhenHandler().endWhen();
        RuleSetInputBuilder.IfBuilder ifBuilder = ruleBuilder.ifThen().ruleIf();
        RuleSetInputBuilder.ThenBuilder thenBuilder = ifBuilder.endIf().ruleThen();
        this.thenTransition(thenBuilder, serverI18n.getText("sd.workflow.close"));
        thenBuilder.endThen().endIfThen();
        ruleBuilder.endRule();
        return this.getRulesetIdFromBuilder(user, builder);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Long> createAutoApproveStandardChangeRequestRuleset(ApplicationUser user, Project project) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        I18nHelper serverI18n = this.i18nFactory.getInstance((ApplicationUser)null);
        Option<CustomField> changeTypeField = this.customFieldsManager.getOrCreateChangeTypeCustomField();
        if (!changeTypeField.isDefined()) {
            return io.atlassian.fugue.Either.left((Object)new AnError(ErrorMessage.builder().message("Change type field not defined").build(), 500));
        }
        RuleSetInputBuilder builder = this.getBuilderService().newRuleSetBuilder().name(i18n.getText("sd.project.template.itil.v2.automation.rule.auto.approve.name")).description(i18n.getText("sd.project.template.itil.v2.automation.rule.auto.approve.description")).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata();
        RuleSetInputBuilder.RuleBuilder ruleBuilder = builder.rule();
        ruleBuilder.when().whenHandler().moduleKey(ISSUE_CREATED_WHEN_HANDLER_COMPLETE_KEY).endWhenHandler().endWhen();
        RuleSetInputBuilder.IfBuilder ifBuilder = ruleBuilder.ifThen().ruleIf();
        Query query = JqlQueryBuilder.newBuilder().where().issueType().eq(i18n.getText("sd.project.template.itil.issuetype.change.name")).and().field(((CustomField)changeTypeField.get()).getFieldName()).eq(i18n.getText("sd.project.template.itil.v2.custom.field.change.type.value.standard")).endWhere().buildQuery();
        ifBuilder.ifCondition().moduleKey(JQL_IF_CONDITION_COMPLETE_KEY).data(this.getBuilderService().newConfigurationDataBuilder().put("jql", this.searchService.getGeneratedJqlString(query)).build()).endIfCondition();
        RuleSetInputBuilder.ThenBuilder thenBuilder = ifBuilder.endIf().ruleThen();
        this.thenTransition(thenBuilder, serverI18n.getText("sd.workflow.approve"));
        thenBuilder.thenAction().moduleKey(COMMENT_ACTION_COMPLETE_KEY).data(this.getBuilderService().newConfigurationDataBuilder().put("comment", i18n.getText("sd.project.template.itil.v2.automation.rule.auto.approve.comment")).put("commentType", "public").build()).endThenAction();
        thenBuilder.endThen().endIfThen();
        ruleBuilder.endRule();
        return this.getRulesetIdFromBuilder(user, builder);
    }

    private io.atlassian.fugue.Either<AnError, Long> getRulesetIdFromBuilder(ApplicationUser user, RuleSetInputBuilder builder) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.getRuleSetInputValidationService().validate(user, builder.build()))).then(validationOutcome -> {
            if (!validationOutcome.getRuleSetValidationResult().isPassed()) {
                return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.BAD_REQUEST, "sd.automation.getting.started.creation.failure", new Object[0]));
            }
            return StepsConverters.newerEither((Either)validationOutcome.getValidatedRuleSet().toRight(() -> this.errorResultHelper.anError(user, HttpStatusCode.BAD_REQUEST, "sd.automation.getting.started.creation.failure", new Object[0])));
        }).then((validationOutcome, validatedRuleSet) -> {
            io.atlassian.fugue.Either rulesetEither = StepsConverters.newerEither((Either)this.getRuleSetService().create(user, validatedRuleSet));
            rulesetEither.left().forEach(error -> this.logger.debug(error.getMessage().getMessage()));
            return rulesetEither;
        }).yield((validationOutcome, validatedRuleSet, result) -> result.getId());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Long> createCustomTransitionOnCommentRuleSet(ApplicationUser user, Project project, DefaultAutomationRuleData ruleData, Option<Integer> index, boolean skipPermissionCheck) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Either<AnError, RuleSet> result = this.createTransitionOnCommentRulesetProper(user, project, index.isDefined() ? i18n.getText("sd.automation.blueprint.comment.transition.name") + " " + index.get() : i18n.getText("sd.automation.blueprint.comment.transition.name"), i18n.getText("sd.automation.blueprint.comment.transition.description"), ruleData, skipPermissionCheck);
        return (io.atlassian.fugue.Either)result.fold(error -> {
            this.logger.debug(error.getMessage().getMessage());
            return io.atlassian.fugue.Either.left((Object)error);
        }, ruleSet -> io.atlassian.fugue.Either.right((Object)ruleSet.getId()));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> deleteRuleset(long ruleSetId) {
        ServiceFlags flags = ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{PermissionCheckFlag.SKIP_PERMISSION_CHECK});
        io.atlassian.fugue.Either ruleSetResult = StepsConverters.newerEither((Either)this.getRuleSetService().getById(StepsConverters.olderOption((Option)Option.none(ApplicationUser.class)), ruleSetId, flags));
        if (ruleSetResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)ruleSetResult.left().get());
        }
        io.atlassian.fugue.Either deleteResult = StepsConverters.newerEither((Either)this.getRuleSetService().delete(StepsConverters.olderOption((Option)Option.none(ApplicationUser.class)), (RuleSet)ruleSetResult.right().get(), flags));
        if (deleteResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)deleteResult.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.UNIT);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Option<String>> getContextConfigForProject(ApplicationUser user, Project project) {
        ServiceFlags flags = ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{PermissionCheckFlag.SKIP_PERMISSION_CHECK});
        io.atlassian.fugue.Either contextConfigResult = StepsConverters.newerEither((Either)this.getProjectRunAsUserContextConfigService().getContextConfigForProject(user, project, flags)).map(StepsConverters::newerOption);
        if (contextConfigResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)contextConfigResult.left().get());
        }
        Option userOpt = ((Option)contextConfigResult.right().get()).flatMap(contextConfig -> {
            if (contextConfig instanceof RunAsSpecificUserContextConfig) {
                return Option.some((Object)((RunAsSpecificUserContextConfig)contextConfig).getUserKey());
            }
            return Option.none(String.class);
        });
        return io.atlassian.fugue.Either.right((Object)userOpt);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> setRunAsUserContextConfigForProject(ApplicationUser user, Project project, boolean skipPermissionCheck) {
        RunAsUserContextConfig runAsUserContextConfig = this.getBuilderService().newRunAsUserContextConfigFactory().forStrategyNameAndUserKey("specificUser", StepsConverters.olderOption((Option)Option.some((Object)user.getKey())));
        ServiceFlags flags = ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{skipPermissionCheck ? PermissionCheckFlag.SKIP_PERMISSION_CHECK : PermissionCheckFlag.PERFORM_PERMISSION_CHECK});
        return StepsConverters.newerEither((Either)this.getProjectRunAsUserContextConfigService().setRunAsUserContextConfigForProject(user, project, runAsUserContextConfig, flags));
    }

    private io.atlassian.fugue.Either<AnError, RuleSet> createTransitionOnCommentRulesetProper(ApplicationUser user, Project project, String name, String description, DefaultAutomationRuleData ruleData, boolean skipPermissionCheck) {
        RuleSetInputBuilder ruleBuilder = this.createBuilder(project, name, description, ruleData);
        io.atlassian.fugue.Either validate2 = StepsConverters.newerEither((Either)this.getRuleSetInputValidationService().validate(user, ruleBuilder.build()));
        if (validate2.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validate2.left().get());
        }
        ValidationOutcome validationOutcome = (ValidationOutcome)validate2.right().get();
        if (!validationOutcome.getRuleSetValidationResult().isPassed()) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.BAD_REQUEST, "sd.automation.getting.started.creation.failure", new Object[0]));
        }
        ValidatedRuleSet validatedRuleSet = (ValidatedRuleSet)validationOutcome.getValidatedRuleSet().get();
        ServiceFlags flags = ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{skipPermissionCheck ? PermissionCheckFlag.SKIP_PERMISSION_CHECK : PermissionCheckFlag.PERFORM_PERMISSION_CHECK});
        return StepsConverters.newerEither((Either)this.getRuleSetService().create(user, validatedRuleSet, flags));
    }

    public RuleSetInputBuilder createBuilder(Project project, String name, String description, DefaultAutomationRuleData ruleData) {
        RuleSetInputBuilder ruleSetInputBuilder = this.getBuilderService().newRuleSetBuilder().name(name).description(description).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata();
        ruleSetInputBuilder = this.addRule(ruleSetInputBuilder, ruleData);
        return ruleSetInputBuilder;
    }

    private RuleSetInputBuilder addRule(RuleSetInputBuilder builder, DefaultAutomationRuleData ruleData) {
        RuleSetInputBuilder.RuleBuilder ruleBuilder = builder.rule();
        this.addCommentWhen(ruleBuilder);
        this.addRespondToCustomerTrigger(ruleBuilder, ruleData.getWaitingForSupportStatus(), ruleData.getToCustomerAction());
        this.addRespondToSupportTrigger(ruleBuilder, ruleData.getWaitingForCustomerStatus(), ruleData.getToSupportAction());
        return ruleBuilder.endRule();
    }

    private RuleSetInputBuilder.RuleBuilder addCommentWhen(RuleSetInputBuilder.RuleBuilder builder) {
        builder.when().whenHandler().moduleKey(ISSUE_COMMENTED_WHEN_HANDLER_COMPLETE_KEY).endWhenHandler().endWhen();
        return builder;
    }

    private RuleSetInputBuilder.RuleBuilder addRespondToCustomerTrigger(RuleSetInputBuilder.RuleBuilder builder, String statusName, String actionName) {
        RuleSetInputBuilder.IfBuilder ifBuilder = builder.ifThen().ruleIf();
        this.ifJQLCondition(ifBuilder, statusName);
        this.ifCommentIsPublic(ifBuilder);
        this.ifUserIsInRole(ifBuilder, "non_customer");
        RuleSetInputBuilder.ThenBuilder thenBuilder = ifBuilder.endIf().ruleThen();
        this.thenTransition(thenBuilder, actionName);
        thenBuilder.endThen().endIfThen();
        return builder;
    }

    private RuleSetInputBuilder.RuleBuilder addRespondToSupportTrigger(RuleSetInputBuilder.RuleBuilder builder, String statusName, String actionName) {
        RuleSetInputBuilder.IfBuilder ifBuilder = builder.ifThen().ruleIf();
        this.ifJQLCondition(ifBuilder, statusName);
        this.ifCommentIsPublic(ifBuilder);
        this.ifUserIsInRole(ifBuilder, "customer");
        RuleSetInputBuilder.ThenBuilder thenBuilder = ifBuilder.endIf().ruleThen();
        this.thenTransition(thenBuilder, actionName);
        thenBuilder.endThen().endIfThen();
        return builder;
    }

    private RuleSetInputBuilder.IfBuilder ifJQLCondition(RuleSetInputBuilder.IfBuilder builder, String statusName) {
        String vpOriginName = this.vpOriginCustomFieldService.getVpOriginCustomField().getName();
        builder.ifCondition().moduleKey(JQL_IF_CONDITION_COMPLETE_KEY).data(this.getBuilderService().newConfigurationDataBuilder().put("jql", "Status = \"" + statusName + "\" and \"" + vpOriginName + "\" is not empty").build()).endIfCondition();
        return builder;
    }

    private RuleSetInputBuilder.IfBuilder ifCommentIsPublic(RuleSetInputBuilder.IfBuilder builder) {
        builder.ifCondition().moduleKey(COMMENT_VISIBILITY_MODULE_COMPLETE_KEY).data(this.getBuilderService().newConfigurationDataBuilder().put("commentType", "public").build()).endIfCondition();
        return builder;
    }

    public RuleSetInputBuilder.IfBuilder ifUserIsInRole(RuleSetInputBuilder.IfBuilder builder, String userType) {
        builder.ifCondition().moduleKey(USER_TYPE_MODULE_COMPLETE_KEY).data(this.getBuilderService().newConfigurationDataBuilder().put("userRoleType", userType).build()).endIfCondition();
        return builder;
    }

    private RuleSetInputBuilder.ThenBuilder thenTransition(RuleSetInputBuilder.ThenBuilder builder, String actionName) {
        builder.thenAction().moduleKey(WORKFLOW_TRANSITION_THEN_ACTION_COMPLETE_KEY).data(this.getBuilderService().newConfigurationDataBuilder().put("workflowAction", actionName).build()).endThenAction();
        return builder;
    }

    private BuilderService getBuilderService() {
        return (BuilderService)ComponentAccessor.getOSGiComponentInstanceOfType(BuilderService.class);
    }

    private RuleSetInputValidationService getRuleSetInputValidationService() {
        return (RuleSetInputValidationService)ComponentAccessor.getOSGiComponentInstanceOfType(RuleSetInputValidationService.class);
    }

    private RuleSetService getRuleSetService() {
        return (RuleSetService)ComponentAccessor.getOSGiComponentInstanceOfType(RuleSetService.class);
    }

    private ProjectRunAsUserContextConfigService getProjectRunAsUserContextConfigService() {
        return (ProjectRunAsUserContextConfigService)ComponentAccessor.getOSGiComponentInstanceOfType(ProjectRunAsUserContextConfigService.class);
    }
}

