/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation.defaultrule;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.automation.defaultrule.DefaultAutomationRuleData;
import com.atlassian.servicedesk.internal.automation.defaultrule.DefaultAutomationRuleService;
import com.atlassian.servicedesk.internal.automation.defaultrule.DefaultAutomationRuleServiceImpl;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.ProjectTemplateCustomFieldsManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultAutomationRuleServiceFactory
implements FactoryBean {
    Logger logger = LoggerFactory.getLogger(DefaultAutomationRuleServiceFactory.class);
    @Autowired
    private VpOriginCustomFieldService vpOriginCustomFieldService;
    @Autowired
    private I18nHelper.BeanFactory i18nFactory;
    @Autowired
    private ErrorResultHelper errorResultHelper;
    @Autowired
    private ProjectTemplateCustomFieldsManager customFieldsManager;
    @Autowired
    private SearchService searchService;

    public Object getObject() throws Exception {
        try {
            Class.forName("com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectRunAsUserContextConfigService");
            this.logger.info("Automation plugin is around. Wiring the proper services implementations...");
            return new DefaultAutomationRuleServiceImpl(this.vpOriginCustomFieldService, this.i18nFactory, this.errorResultHelper, this.customFieldsManager, this.searchService);
        }
        catch (Exception e) {
            this.logger.info("Automation plugin is NOT around. Wiring no-op services implementations...");
            return new NoOpAutomationRuleService(this.errorResultHelper);
        }
    }

    public Class getObjectType() {
        return DefaultAutomationRuleService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private static class NoOpAutomationRuleService
    implements DefaultAutomationRuleService {
        final ErrorResultHelper errorResultHelper;

        public NoOpAutomationRuleService(ErrorResultHelper errorResultHelper) {
            this.errorResultHelper = errorResultHelper;
        }

        @Override
        public io.atlassian.fugue.Either<AnError, Long> createTransitionOnCommentRuleset(ApplicationUser user, Project project) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "No-op method called", new Object[0]));
        }

        @Override
        public io.atlassian.fugue.Either<AnError, Long> createUpdateOnLinkedIssueTransitionRuleset(ApplicationUser user, Project project) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "No-op method called", new Object[0]));
        }

        @Override
        public io.atlassian.fugue.Either<AnError, Long> createAutoCloseAfterResolveRuleset(ApplicationUser user, Project project, TimeMetric timeMetric) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "No-op method called", new Object[0]));
        }

        @Override
        public io.atlassian.fugue.Either<AnError, Long> createAutoApproveStandardChangeRequestRuleset(ApplicationUser user, Project project) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "No-op method called", new Object[0]));
        }

        @Override
        public io.atlassian.fugue.Either<AnError, Long> createCustomTransitionOnCommentRuleSet(ApplicationUser user, Project project, DefaultAutomationRuleData ruleData, Option<Integer> index, boolean skipPermissionCheck) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "No-op method called", new Object[0]));
        }

        @Override
        public io.atlassian.fugue.Either<AnError, Unit> deleteRuleset(long ruleSetId) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "No-op method called", new Object[0]));
        }

        @Override
        public io.atlassian.fugue.Either<AnError, Option<String>> getContextConfigForProject(ApplicationUser user, Project project) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "No-op method called", new Object[0]));
        }

        @Override
        public io.atlassian.fugue.Either<AnError, Unit> setRunAsUserContextConfigForProject(ApplicationUser user, Project project, boolean skipPermissionCheck) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "No-op method called", new Object[0]));
        }
    }
}

