/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation.blueprints;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdService;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevelService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class KeepOnTopOfSLABlueprint
implements Blueprint {
    public static final String SERVICE_DESK_AUTOMATION_MODULES_PLUGIN_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin";
    public static final String ALERT_USER_ACTION_MODULE_KEY = "alert-user-action";
    public static final String ALERT_USER_ACTION_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:alert-user-action";
    public static final String JQL_IF_CONDITION_MODULE_KEY = "jql-if-condition";
    public static final String JQL_IF_CONDITION_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:jql-if-condition";
    private static final String SLA_THRESHOLD_COMPLETE_KEY = "com.atlassian.servicedesk:sla-threshold-when-handler";
    private final BuilderService builderService;
    private final ErrorResultHelper errorResultHelper;
    private final I18nHelper.BeanFactory i18nFactory;
    private final InternalServiceDeskService serviceDeskService;
    private final InternalTimeMetricService timeMetricService;
    private final SlaThresholdService slaThresholdService;
    private final UserFactory userFactory;

    public KeepOnTopOfSLABlueprint(BuilderService builderService, ErrorResultHelper errorResultHelper, I18nHelper.BeanFactory i18nFactory, InternalServiceDeskService serviceDeskService, InternalTimeMetricService timeMetricService, SlaThresholdService slaThresholdService, UserFactory userFactory) {
        this.builderService = builderService;
        this.errorResultHelper = errorResultHelper;
        this.i18nFactory = i18nFactory;
        this.serviceDeskService = serviceDeskService;
        this.timeMetricService = timeMetricService;
        this.slaThresholdService = slaThresholdService;
        this.userFactory = userFactory;
    }

    public Either<AnError, RuleSetInput> generateRuleSetInput(@Nonnull Blueprint.BlueprintParam blueprintParam) {
        ApplicationUser currentUser = blueprintParam.getUser();
        List projectList = blueprintParam.getProjectContext().getProjects();
        if (projectList.isEmpty()) {
            return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.missing.project", new Object[0]);
        }
        Project project = (Project)projectList.get(0);
        return Steps.begin(this.getServiceDesk(currentUser, project)).then(serviceDesk -> this.getFirstTimeMetric(currentUser, (ServiceDesk)serviceDesk)).then((serviceDesk, timeMetric) -> this.getSlaThresholds(currentUser, (TimeMetric)((Object)timeMetric))).then((serviceDesk, timeMetric, slaThresholds) -> this.buildRuleSetForSlaThresholds(currentUser, project, (TimeMetric)((Object)timeMetric), (List<SlaThreshold>)slaThresholds)).yield((serviceDesk, timeMetric, slaThresholds, ruleSet) -> ruleSet);
    }

    private Either<AnError, ServiceDesk> getServiceDesk(ApplicationUser currentUser, Project project) {
        return Steps.begin((Either)this.userFactory.wrap(currentUser)).then(checkedUser -> StepsConverters.olderEither((io.atlassian.fugue.Either)this.serviceDeskService.getServiceDeskForProject(checkedUser, project, false))).yield((checkedUser, serviceDesk) -> serviceDesk).leftMap(error -> this.errorResultHelper.badRequest400("sd.automation.blueprint.error.missing.servicedesk", new Object[0]).build());
    }

    private Either<AnError, TimeMetric> getFirstTimeMetric(ApplicationUser currentUser, ServiceDesk serviceDesk) {
        List<TimeMetric> timeMetrics = this.timeMetricService.getTimeMetrics(currentUser, serviceDesk);
        if (timeMetrics.isEmpty()) {
            return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.no.time.metrics", new Object[0]);
        }
        return Either.right((Object)((Object)timeMetrics.get(0)));
    }

    private Either<AnError, List<SlaThreshold>> getSlaThresholds(ApplicationUser currentUser, TimeMetric timeMetric) {
        return StepsConverters.olderEither(this.slaThresholdService.getThresholds(currentUser, timeMetric)).leftMap(error -> this.errorResultHelper.badRequest400("sd.automation.blueprint.error.no.time.metric.thresholds", new Object[0]).build());
    }

    private Either<AnError, RuleSetInput> buildRuleSetForSlaThresholds(ApplicationUser currentUser, Project project, TimeMetric timeMetric, List<SlaThreshold> slaThresholds) {
        for (SlaThreshold threshold : slaThresholds) {
            if (threshold.getRemainingTime() != UrgencyLevelService.AT_RISK_REMAINING_TIME_THRESHOLD_MILLIS) continue;
            return Either.right((Object)this.buildRuleset(currentUser, project, timeMetric, threshold).build());
        }
        return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.no.time.metric.threshold.missing", new Object[0]);
    }

    private RuleSetInputBuilder buildRuleset(ApplicationUser currentUser, Project project, TimeMetric timeMetric, SlaThreshold slaThreshold) {
        I18nHelper i18n = this.i18nFactory.getInstance(currentUser);
        RuleSetInputBuilder builder = this.builderService.newRuleSetBuilder().name(i18n.getText("sd.sla.threshold.when.blueprint.name")).description(i18n.getText("sd.sla.threshold.when.blueprint.description")).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata().rule().when().whenHandler().moduleKey(SLA_THRESHOLD_COMPLETE_KEY).data(this.builderService.newConfigurationDataBuilder().put("projectKey", project.getKey()).put("metricId", timeMetric.getId().toString()).put("thresholdTime", slaThreshold.getRemainingTime().toString()).build()).endWhenHandler().endWhen().ifThen().ruleIf().ifCondition().moduleKey(JQL_IF_CONDITION_COMPLETE_KEY).data(this.builderService.newConfigurationDataBuilder().put("jql", "").build()).endIfCondition().endIf().ruleThen().thenAction().moduleKey(ALERT_USER_ACTION_COMPLETE_KEY).data(this.builderService.newConfigurationDataBuilder().put("userKeys", this.getUserAsJsonArray(currentUser)).build()).endThenAction().endThen().endIfThen().endRule();
        return builder;
    }

    private String getUserAsJsonArray(ApplicationUser user) {
        JSONArray jsonArray = new JSONArray((Collection)Lists.newArrayList((Object[])new String[]{user.getKey()}));
        return jsonArray.toString();
    }
}

