/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.utils.context.ServiceDeskOutsideCustomerPermissionContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.internal.spi.execution.RuleExecutionPreprocessor;
import io.atlassian.fugue.Option;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutsideCustomerContextRuleRuleExecutionPreprocessor
implements RuleExecutionPreprocessor {
    private static final Logger log = LoggerFactory.getLogger(OutsideCustomerContextRuleRuleExecutionPreprocessor.class);
    public static final String IN_OUTSIDER_CUSTOMER_CONTEXT_KEY = "inOutsiderCustomerContext";
    public static final String ISSUE_ID = "issueId";
    public static final String USER_KEY = "userKey";
    private final ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext;
    private final RuleMessageBuilderService ruleMessageBuilderService;

    public OutsideCustomerContextRuleRuleExecutionPreprocessor(ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext, RuleMessageBuilderService ruleMessageBuilderService) {
        this.serviceDeskOutsideCustomerPermissionContext = serviceDeskOutsideCustomerPermissionContext;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
    }

    public Either<AnError, RuleMessage> preprocess(@Nonnull RuleExecutionPreprocessor.PreprocessorParams preprocessorParams) {
        Set<ServiceDeskOutsideCustomerPermissionContext.OutsideCustomerIssuePermissionContext> outsideCustomerContext = this.serviceDeskOutsideCustomerPermissionContext.getOutsideCustomerContext();
        if (outsideCustomerContext.isEmpty()) {
            return Either.right((Object)preprocessorParams.getRuleMessage());
        }
        JSONArray outsiderJsonArray = new JSONArray();
        try {
            outsideCustomerContext.forEach(context -> {
                JSONObject outsiderContextJson = new JSONObject();
                try {
                    outsiderContextJson.put(ISSUE_ID, Option.option((Object)context.getIssue().getId()).getOrThrow(() -> new RuntimeException("Issue ID must exist, but does not for " + context.getIssue())));
                    outsiderContextJson.put(USER_KEY, Option.option((Object)context.getCheckedUser().getKey()).getOrThrow(() -> new RuntimeException("User Key must exist, but does not for " + context.getCheckedUser())));
                    outsiderJsonArray.put((Object)outsiderContextJson);
                }
                catch (JSONException e) {
                    throw new RuntimeException("Failed to create JSON for preprocessor", e);
                }
            });
        }
        catch (RuntimeException exception) {
            log.warn("There was an error running the Outsider Automation Preprocessor. Skipping this context", (Throwable)exception);
            return Either.right((Object)preprocessorParams.getRuleMessage());
        }
        RuleMessage updatedRuleMessage = this.ruleMessageBuilderService.builder(preprocessorParams.getRuleMessage()).putValue(IN_OUTSIDER_CUSTOMER_CONTEXT_KEY, outsiderJsonArray.toString()).build();
        return Either.right((Object)updatedRuleMessage);
    }
}

