/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.internal.utils.context.ServiceDeskOutsideCustomerPermissionContext;
import com.atlassian.servicedesk.plugins.automation.internal.spi.execution.RuleExecutionInterceptor;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutsideCustomerContextRuleRuleExecutionInterceptor
implements RuleExecutionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OutsideCustomerContextRuleRuleExecutionInterceptor.class);
    private final ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext;
    private final IssueManager issueManager;
    private final UserFactory userFactory;

    public OutsideCustomerContextRuleRuleExecutionInterceptor(ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext, IssueManager issueManager, UserFactory userFactory) {
        this.serviceDeskOutsideCustomerPermissionContext = serviceDeskOutsideCustomerPermissionContext;
        this.issueManager = issueManager;
        this.userFactory = userFactory;
    }

    public void doIntercept(RuleExecutionInterceptor.RuleExecutionParam ruleExecutionParam, RuleExecutionInterceptor.InterceptorChain interceptorChain) {
        io.atlassian.fugue.Option outsiderJsonArray;
        try {
            outsiderJsonArray = StepsConverters.newerOption((Option)ruleExecutionParam.getRuleMessage().getValue("inOutsiderCustomerContext")).map(value -> {
                try {
                    return new JSONArray(value);
                }
                catch (JSONException e) {
                    throw new RuntimeException("Failed to parse the JSON for preprocessor", e);
                }
            });
        }
        catch (Exception exception) {
            log.warn("There was an error looking up the context while running the Outsider Automation Interceptor. Skipping this context", (Throwable)exception);
            interceptorChain.next();
            return;
        }
        if (outsiderJsonArray.isEmpty()) {
            interceptorChain.next();
        } else {
            JSONArray outsiderContextArray = (JSONArray)outsiderJsonArray.get();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            try {
                int i = 0;
                while (i < outsiderContextArray.length()) {
                    int index = i++;
                    JSONObject json = outsiderContextArray.getJSONObject(index);
                    MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(json.getLong("issueId")));
                    String userKey = json.getString("userKey");
                    CheckedUser checkedUser = (CheckedUser)this.userFactory.wrapUserKey(userKey).getOrThrow(() -> new RuntimeException("Invalid user key " + userKey + " from JSON array index " + index + " while setting up the context from interceptor"));
                    builder.add((Object)new ServiceDeskOutsideCustomerPermissionContext.OutsideCustomerIssuePermissionContext(checkedUser, (Issue)issue));
                }
            }
            catch (Exception exception) {
                log.warn("There was an error extracting the context while running the Outsider Automation Interceptor. Skipping this context", (Throwable)exception);
                interceptorChain.next();
                return;
            }
            this.serviceDeskOutsideCustomerPermissionContext.inOutsideCustomerContext((Set<ServiceDeskOutsideCustomerPermissionContext.OutsideCustomerIssuePermissionContext>)builder.build(), FpKit.runnableToNoExceptionsCallable(() -> ((RuleExecutionInterceptor.InterceptorChain)interceptorChain).next()));
        }
    }

    public void doIntercept(RuleExecutionInterceptor.WhenExecutionParam whenExecutionParam, RuleExecutionInterceptor.InterceptorChain interceptorChain) {
        interceptorChain.next();
    }
}

