/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.automation.AutomationBridge;
import com.atlassian.servicedesk.internal.automation.AutomationBridgeImpl;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutomationBridgeFactory
implements FactoryBean {
    private final Logger logger = LoggerFactory.getLogger(AutomationBridgeFactory.class);
    @Autowired
    private UserManager userManager;
    @Autowired
    private SafeRunner safeRunner;
    @Autowired
    private ServiceDeskPermissions sdPermissions;
    @Autowired
    private UserFactory userFactory;

    public Object getObject() throws Exception {
        try {
            Class.forName("com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectRunAsUserContextConfigService");
            this.logger.info("Automation plugin is around. Wiring the proper services implementations...");
            return new AutomationBridgeImpl(this.userManager, this.safeRunner, this.sdPermissions, this.userFactory);
        }
        catch (Exception e) {
            this.logger.info("Automation plugin is NOT around. Wiring no-op services implementations...");
            return new NoOpAutomationBridge();
        }
    }

    public Class getObjectType() {
        return AutomationBridge.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private static class NoOpAutomationBridge
    implements AutomationBridge {
        private NoOpAutomationBridge() {
        }

        @Override
        public Boolean isTheRunAsUserContextConfigInvalid(ApplicationUser user, Project project) {
            return false;
        }
    }
}

