/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.analytics;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.analytics.ConversationalAnalyticEvent;
import com.atlassian.servicedesk.internal.analytics.ServiceDeskInternalAnalyticsSourceService;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.analytics.ServiceDeskAnalyticsSourceService;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ServiceDeskAnalyticsSourceService.class})
public class ServiceDeskInternalAnalyticsSourceServiceImpl
implements ServiceDeskInternalAnalyticsSourceService {
    private AnalyticsService analyticsService;

    @Autowired
    public ServiceDeskInternalAnalyticsSourceServiceImpl(AnalyticsService analyticsService) {
        this.analyticsService = analyticsService;
    }

    @Override
    public void fireRequestOpenedViaEmailEvent(String source, Long projectId) {
        if ("notification-email".equals(source)) {
            ConversationalAnalyticEvent event = new ConversationalAnalyticEvent("servicedesk.action.request.opened.via.email", projectId);
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)event);
        }
    }

    @Override
    public void firePortalOpenedViaEmailEvent(String source, Long projectId) {
        if ("notification-email".equals(source)) {
            ConversationalAnalyticEvent event = new ConversationalAnalyticEvent("servicedesk.action.portal.opened.via.email", projectId);
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)event);
        }
    }

    @Override
    public void fireRequestRaisedViaEmailEvent(String source, Long projectId) {
        if ("notification-email".equals(source)) {
            ConversationalAnalyticEvent event = new ConversationalAnalyticEvent("servicedesk.action.request.raised.via.email", projectId);
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)event);
        }
    }

    @Override
    public void fireRequestUnsubscribedRaisedViaEmailEvent(@Nonnull Long projectId) {
        ConversationalAnalyticEvent event = new ConversationalAnalyticEvent("servicedesk.action.request.unsubscribe.raised.via.email", projectId);
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)event);
    }

    public String enrichURLWithSDASource(String url, String source) {
        StringBuilder result = new StringBuilder(url);
        if (url.contains("?")) {
            result.append("&");
        } else {
            result.append("?");
        }
        result.append("sda_source");
        result.append("=");
        result.append(source);
        return result.toString();
    }
}

