/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.analytics;

import com.atlassian.fugue.Option;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.analytics.IssueEventAnalyticsHelper;
import com.atlassian.servicedesk.internal.analytics.SDIssueEventType;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.atlassian.servicedesk.internal.util.IssueEventTypeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={IssueEventHelper.class})
@Component
public class IssueEventAnalyticsHelperImpl
implements IssueEventAnalyticsHelper,
IssueEventHelper {
    private final IssueManager issueManager;
    private final UserManager userManager;
    private final UserFactory userFactory;
    private final IssueEventTypeHelper issueEventTypeHelper;

    @Autowired
    public IssueEventAnalyticsHelperImpl(IssueManager issueManager, UserManager userManager, UserFactory userFactory, IssueEventTypeHelper issueEventTypeHelper) {
        this.issueManager = issueManager;
        this.userManager = userManager;
        this.userFactory = userFactory;
        this.issueEventTypeHelper = issueEventTypeHelper;
    }

    @Override
    public io.atlassian.fugue.Option<CheckedUser> getEventInitiatior(IssueEvent issueEvent) {
        return io.atlassian.fugue.Option.option((Object)issueEvent.getUser()).flatMap(user -> StepsConverters.newerOption((Option)this.userFactory.wrap(user).toOption()));
    }

    @Override
    public io.atlassian.fugue.Option<CheckedUser> getEventInitiatior(IssueChangedEvent issueEvent) {
        io.atlassian.fugue.Option author = io.atlassian.fugue.Option.option(issueEvent.getAuthor().orElse(null));
        return author.flatMap(user -> StepsConverters.newerOption((Option)this.userFactory.wrap(user).toOption()));
    }

    @Override
    public io.atlassian.fugue.Option<Comment> getCommentOption(IssueEvent issueEvent) {
        return io.atlassian.fugue.Option.option((Object)issueEvent.getComment());
    }

    @Override
    public io.atlassian.fugue.Option<Issue> getIssueOption(IssueEvent issueEvent) {
        return io.atlassian.fugue.Option.option((Object)issueEvent.getIssue());
    }

    @Override
    public io.atlassian.fugue.Option<Project> getProjectOption(IssueEvent issueEvent) {
        return io.atlassian.fugue.Option.option((Object)issueEvent.getProject());
    }

    private io.atlassian.fugue.Option<ChangeHistory> getChangeHistory(IssueEvent issueEvent) {
        return io.atlassian.fugue.Option.option((Object)issueEvent.getChangeLog()).map(changeLog -> new ChangeHistory(changeLog, this.issueManager, this.userManager));
    }

    public List<ChangeItemBean> getChangeItemBeans(IssueEvent issueEvent) {
        return (List)this.getChangeHistory(issueEvent).map(ChangeHistory::getChangeItemBeans).getOrElse(Collections.emptyList());
    }

    public boolean isCreatedEvent(IssueEvent event) {
        boolean isEventTypeCreated = this.issueEventTypeHelper.isEventOfType(event, EventType.ISSUE_CREATED_ID);
        return event.getChangeLog() == null && isEventTypeCreated && event.getComment() == null;
    }

    public boolean isDeletedEvent(IssueEvent event) {
        return this.issueEventTypeHelper.isEventOfType(event, EventType.ISSUE_DELETED_ID);
    }

    @Override
    public List<SDIssueEventType> getSDIssueEventTypes(IssueEvent issueEvent) {
        ArrayList<SDIssueEventType> sdEventTypes = new ArrayList<SDIssueEventType>();
        Long eventType = this.issueEventTypeHelper.getBaseEventTypeId(issueEvent);
        List<ChangeItemBean> changes = this.getChangeItemBeans(issueEvent);
        if (EventType.ISSUE_GENERICEVENT_ID.equals(eventType) && this.isStatusTransitionEvent(changes)) {
            sdEventTypes.add(SDIssueEventType.TransitionedIssueEventType);
        } else if (EventType.ISSUE_ASSIGNED_ID.equals(eventType)) {
            sdEventTypes.add(SDIssueEventType.AssignedIssueEventType);
        } else if (EventType.ISSUE_UPDATED_ID.equals(eventType)) {
            if (this.isAssignEvent(changes)) {
                sdEventTypes.add(SDIssueEventType.AssignedIssueEventType);
            } else {
                sdEventTypes.add(SDIssueEventType.EditedIssueEventType);
            }
        }
        if (issueEvent.getComment() != null) {
            sdEventTypes.add(SDIssueEventType.CommentedIssueEventType);
        }
        return Collections.unmodifiableList(sdEventTypes);
    }

    @Override
    public List<SDIssueEventType> getSDIssueEventTypes(IssueChangedEvent issueEvent) {
        ArrayList<SDIssueEventType> sdEventTypes = new ArrayList<SDIssueEventType>();
        Collection changes = issueEvent.getChangeItems();
        if (this.isStatusTransitionEvent(changes)) {
            sdEventTypes.add(SDIssueEventType.TransitionedIssueEventType);
            if (this.isResolvedEvent(changes)) {
                sdEventTypes.add(SDIssueEventType.ResolvedIssueEventType);
            }
        } else if (this.isAssignEvent(changes)) {
            sdEventTypes.add(SDIssueEventType.AssignedIssueEventType);
        } else {
            sdEventTypes.add(SDIssueEventType.EditedIssueEventType);
        }
        if (issueEvent.getComment().isPresent()) {
            sdEventTypes.add(SDIssueEventType.CommentedIssueEventType);
        }
        return Collections.unmodifiableList(sdEventTypes);
    }

    private boolean isStatusTransitionEvent(Collection<ChangeItemBean> changes) {
        return changes.stream().anyMatch(changeItemBean -> "status".equals(changeItemBean.getField()));
    }

    private boolean isAssignEvent(Collection<ChangeItemBean> changes) {
        return changes.stream().anyMatch(changeItemBean -> "assignee".equals(changeItemBean.getField()));
    }

    private boolean isResolvedEvent(Collection<ChangeItemBean> changes) {
        return changes.stream().map(ChangeItemBean::getField).anyMatch("resolution"::equals);
    }
}

