/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.admin;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.admin.EmailCreateCustomerMode;
import com.atlassian.servicedesk.internal.admin.EmailRequestsSettingsManager;
import com.atlassian.servicedesk.internal.admin.EmailRequestsSettingsService;
import com.atlassian.servicedesk.internal.admin.EmailTrimmingMode;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailRequestsSettingsServiceImpl
implements EmailRequestsSettingsService {
    private final CommonErrors commonErrors;
    private final FeatureManager featureManager;
    private final PermissionService permissionService;
    private final EmailRequestsSettingsManager emailRequestsSettingsManager;
    private final ErrorResultHelper errorResultHelper;
    private static final String OUTSIDER_COMMENTS_VIOLATION_I18N = "sd.admin.incoming.email.outsider.comments.permission.violation";
    private static final String FORMATTING_VIOLATION_I18N = "sd.admin.incoming.email.formatting.permission.violation";
    private static final String TRIMMING_VIOLATION_I18N = "sd.admin.incoming.email.trimming.none.permission.violation";
    private static final String CREATE_CUSTOMERS_VIOLATION_I18N = "sd.admin.incoming.email.create.customer.mode.permission.violation";

    @Autowired
    public EmailRequestsSettingsServiceImpl(CommonErrors commonErrors, FeatureManager featureManager, PermissionService permissionService, EmailRequestsSettingsManager emailRequestsSettingsManager, ErrorResultHelper errorResultHelper) {
        this.commonErrors = commonErrors;
        this.featureManager = featureManager;
        this.permissionService = permissionService;
        this.emailRequestsSettingsManager = emailRequestsSettingsManager;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public Either<AnError, EmailTrimmingMode> setEmailTrimmingMode(ApplicationUser user, @Nonnull EmailTrimmingMode emailTrimmingMode) {
        if (!this.permissionService.isJiraAdministrator(user)) {
            return Either.left((Object)this.permissionViolation(TRIMMING_VIOLATION_I18N));
        }
        if (!emailTrimmingMode.isModeAvailable()) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return this.emailRequestsSettingsManager.setTrimmingMode(emailTrimmingMode);
    }

    @Override
    public Either<AnError, Boolean> setEmailFormattingEnabled(ApplicationUser user, boolean enabled) {
        if (!this.permissionService.isJiraAdministrator(user)) {
            return Either.left((Object)this.permissionViolation(FORMATTING_VIOLATION_I18N));
        }
        return this.emailRequestsSettingsManager.setFormattingEnabled(enabled);
    }

    @Override
    public Either<AnError, Boolean> setOutsiderCommentsEnabled(ApplicationUser user, boolean enabled) {
        if (!this.permissionService.isJiraAdministrator(user)) {
            return Either.left((Object)this.permissionViolation(OUTSIDER_COMMENTS_VIOLATION_I18N));
        }
        if (!this.featureManager.isEnabled(SDFeatureFlags.OUTSIDER_COMMENTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return this.emailRequestsSettingsManager.setOutsiderCommentsEnabled(enabled);
    }

    @Override
    public Either<AnError, EmailCreateCustomerMode> setEmailCreateCustomerMode(ApplicationUser user, @Nonnull EmailCreateCustomerMode emailCreateCustomerMode) {
        if (!this.permissionService.isJiraAdministrator(user)) {
            return Either.left((Object)this.permissionViolation(CREATE_CUSTOMERS_VIOLATION_I18N));
        }
        if (!this.featureManager.isEnabled(SDFeatureFlags.WHO_CREATE_CUSTOMERS_BY_EMAIL_SETTING)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return this.emailRequestsSettingsManager.setEmailCreateCustomerMode(emailCreateCustomerMode);
    }

    @Override
    public EmailTrimmingMode getEmailTrimmingMode() {
        return this.emailRequestsSettingsManager.getTrimmingMode();
    }

    @Override
    public boolean getEmailFormattingEnabled() {
        return this.emailRequestsSettingsManager.getFormattingEnabled();
    }

    @Override
    public boolean getOutsiderCommentsEnabled() {
        if (!this.featureManager.isEnabled(SDFeatureFlags.OUTSIDER_COMMENTS)) {
            return false;
        }
        return this.emailRequestsSettingsManager.getOutsiderCommentsEnabled();
    }

    @Override
    public EmailCreateCustomerMode getEmailCreateCustomerMode() {
        if (!this.featureManager.isEnabled(SDFeatureFlags.WHO_CREATE_CUSTOMERS_BY_EMAIL_SETTING)) {
            return EmailRequestsSettingsManager.DEFAULT_CREATE_CUSTOMER_MODE;
        }
        return this.emailRequestsSettingsManager.getEmailCreateCustomerMode();
    }

    private AnError permissionViolation(String key) {
        return this.errorResultHelper.unauthorized401(key, new Object[0]).build();
    }
}

