/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.admin;

import com.atlassian.servicedesk.internal.admin.EmailRequestsSettingsManager;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EmailCreateCustomerMode {
    YES_ALWAYS_AGENTS_OR_PUBLIC_SIGNUP(true, true, "sd.admin.incoming.email.create.customer.mode.agent.always"),
    YES_ONLY_PUBLIC_SIGNUP(false, true, "sd.admin.incoming.email.create.customer.mode.public.signup"),
    NO_NEVER(false, false, "sd.admin.incoming.email.create.customer.mode.never");

    private static final List<EmailCreateCustomerMode> VALUES;
    private static final Logger log;
    private final boolean canAgentCreateAlways;
    private final boolean canAnyoneCreateWithPublicSignup;
    private final String i18nQuestionKey;

    private EmailCreateCustomerMode(boolean canAgentCreateAlways, boolean canAnyoneCreateWithPublicSignup, String i18nQuestionKey) {
        this.canAgentCreateAlways = canAgentCreateAlways;
        this.canAnyoneCreateWithPublicSignup = canAnyoneCreateWithPublicSignup;
        this.i18nQuestionKey = i18nQuestionKey;
    }

    public boolean isCanAgentCreateAlways() {
        return this.canAgentCreateAlways;
    }

    public boolean isCanAnyoneCreateWithPublicSignup() {
        return this.canAnyoneCreateWithPublicSignup;
    }

    public String getI18nQuestionKey() {
        return this.i18nQuestionKey;
    }

    public static EmailCreateCustomerMode findEmailCreateCustomerMode(boolean canAgentCreateAlways, boolean canAnyoneCreateWithPublicSignup) {
        List collect = VALUES.stream().filter(mode -> mode.isCanAgentCreateAlways() == canAgentCreateAlways && mode.isCanAnyoneCreateWithPublicSignup() == canAnyoneCreateWithPublicSignup).collect(Collectors.toList());
        if (collect.size() == 1) {
            return (EmailCreateCustomerMode)((Object)collect.get(0));
        }
        if (collect.size() > 1) {
            EmailCreateCustomerMode firstMatch = (EmailCreateCustomerMode)((Object)collect.get(0));
            log.warn("Erroneously found more than 1 potential match. Found {} for canAgentCreateAlways = {} and canAnyoneCreateWithPublicSignup = {} : returning first match of {}", new Object[]{collect, canAgentCreateAlways, canAnyoneCreateWithPublicSignup, firstMatch});
            return firstMatch;
        }
        log.warn("Found no matches for canAgentCreateAlways = {} and canAnyoneCreateWithPublicSignup = {} : returning default of {}", new Object[]{canAgentCreateAlways, canAnyoneCreateWithPublicSignup, EmailRequestsSettingsManager.DEFAULT_CREATE_CUSTOMER_MODE});
        return EmailRequestsSettingsManager.DEFAULT_CREATE_CUSTOMER_MODE;
    }

    static {
        VALUES = ImmutableList.copyOf(Arrays.asList(EmailCreateCustomerMode.values()));
        log = LoggerFactory.getLogger(EmailCreateCustomerMode.class);
    }
}

