/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.actions.helper;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import webwork.action.Action;
import webwork.action.ActionSupport;

@Component
public class RequestTypeEditFieldRenderer {
    @TenantAware(value=TenancyScope.TENANTLESS)
    private static final Map<String, Object> FIELD_RENDER_PARAMS = ImmutableMap.builder().put((Object)"noHeader", (Object)"true").put((Object)"theme", (Object)"aui").put((Object)"isFirstField", (Object)Boolean.TRUE).put((Object)"isLastField", (Object)Boolean.TRUE).build();
    private final IssueHelper issueHelper;
    private final I18nHelper i18nHelper;

    @Autowired
    public RequestTypeEditFieldRenderer(IssueHelper issueHelper, I18nHelper i18nHelper) {
        this.issueHelper = issueHelper;
        this.i18nHelper = i18nHelper;
    }

    public EditFieldRenderer buildEditFieldRenderer(Project project, IssueType issueType, OrderableField field, Map<String, String[]> actionParams) {
        MutableIssue issue = this.issueHelper.createIssue(project, issueType);
        HashMap<String, Object> fieldValuesHolder = new HashMap<String, Object>();
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, fieldValuesHolder);
        FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.issueHelper.createFieldScreenRenderer((Issue)issue).getFieldScreenRenderLayoutItem(field);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (field.hasParam(actionParams)) {
            field.populateFromParams(fieldValuesHolder, actionParams);
            field.validateParams((OperationContext)operationContext, (ErrorCollection)errorCollection, this.i18nHelper, (Issue)issue, fieldScreenRenderLayoutItem);
        }
        if (errorCollection.getErrors().isEmpty() && !fieldValuesHolder.isEmpty()) {
            this.addErrorIfEmptyFieldPresetValue(field, fieldValuesHolder, errorCollection);
        }
        return new EditFieldRenderer(actionWithErrorsApplied -> field.getCreateHtml(fieldScreenRenderLayoutItem.getFieldLayoutItem(), (OperationContext)operationContext, actionWithErrorsApplied.getAction(), (Issue)issue, FIELD_RENDER_PARAMS), errorCollection);
    }

    private void addErrorIfEmptyFieldPresetValue(OrderableField field, Map<String, Object> fieldValuesHolder, SimpleErrorCollection errorCollection) {
        Option rawValueOpt = Option.option((Object)field.getValueFromParams(fieldValuesHolder));
        if (this.isEmptyFieldValueOfKnownType((Option<Object>)rawValueOpt)) {
            errorCollection.addError(field.getId(), this.i18nHelper.getText("sd.error.field.hidden.nopreset"));
        }
    }

    private boolean isEmptyFieldValueOfKnownType(Option<Object> rawValueOpt) {
        if (rawValueOpt.isEmpty()) {
            return true;
        }
        Object rawValue = rawValueOpt.get();
        if (rawValue instanceof String) {
            return ((String)rawValue).trim().isEmpty();
        }
        if (rawValue instanceof List) {
            return ((List)rawValue).isEmpty();
        }
        return false;
    }

    public static class ActionWithErrorsApplied {
        private final Action action;

        private ActionWithErrorsApplied(Action action) {
            this.action = action;
        }

        public Action getAction() {
            return this.action;
        }
    }

    public static class EditFieldRenderer {
        private final Function<ActionWithErrorsApplied, String> editFieldHtmlRenderer;
        private final SimpleErrorCollection errorCollection;

        private EditFieldRenderer(Function<ActionWithErrorsApplied, String> editFieldHtmlRenderer, SimpleErrorCollection errorCollection) {
            this.editFieldHtmlRenderer = editFieldHtmlRenderer;
            this.errorCollection = errorCollection;
        }

        public String renderEditFieldHtml(ActionWithErrorsApplied actionWithErrorsApplied) {
            return (String)this.editFieldHtmlRenderer.get((Object)actionWithErrorsApplied);
        }

        public SimpleErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        public boolean hasAnyErrors() {
            return this.errorCollection.hasAnyErrors();
        }

        public ActionWithErrorsApplied applyErrorsToAction(ActionSupport action) {
            action.setErrorMessages(this.errorCollection.getErrorMessages());
            action.setErrors(this.errorCollection.getErrors());
            return new ActionWithErrorsApplied((Action)action);
        }
    }
}

