/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.actions;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.actions.ServiceDeskPluginActionSupport;
import com.atlassian.servicedesk.internal.actions.helper.RequestTypeEditFieldRenderer;
import com.atlassian.servicedesk.internal.api.eyeball.EyeballService;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.jira.issuetype.ServiceDeskIssueTypeManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.history.ServiceDeskUserHistoryService;
import com.atlassian.servicedesk.internal.soy.SoyRenderingHelper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;
import webwork.action.ActionSupport;

public class FieldDefaultValuesAction
extends ServiceDeskPluginActionSupport {
    private final UserFactory userFactory;
    private final InternalPortalService internalPortalService;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final FieldManager fieldManager;
    private final RequestTypeInternalService requestTypeInternalService;
    private final ServiceDeskIssueTypeManager serviceDeskIssueTypeManager;
    private final RequestTypeEditFieldRenderer requestTypeEditFieldRenderer;
    private io.atlassian.fugue.Option<String> portalKeyOpt = io.atlassian.fugue.Option.none();
    private io.atlassian.fugue.Option<Integer> requestTypeIdOpt = io.atlassian.fugue.Option.none();
    private io.atlassian.fugue.Option<String> fieldIdOpt = io.atlassian.fugue.Option.none();
    private boolean isHideAction = false;

    public FieldDefaultValuesAction(EyeballService eyeballService, ServiceDeskOperationalStatus serviceDeskOperationalStatus, SoyRenderingHelper soyRenderingHelper, I18nHelper i18nHelper, WebResourceUrlProvider webResourceUrlProvider, ServiceDeskUserHistoryService sdHistoryService, UserFactory userFactory, InternalPortalService internalPortalService, InternalServiceDeskProjectManager internalServiceDeskProjectManager, FieldManager fieldManager, RequestTypeInternalService requestTypeInternalService, ServiceDeskIssueTypeManager serviceDeskIssueTypeManager, RequestTypeEditFieldRenderer requestTypeEditFieldRenderer) {
        super(eyeballService, serviceDeskOperationalStatus, soyRenderingHelper, i18nHelper, webResourceUrlProvider, sdHistoryService);
        this.userFactory = userFactory;
        this.internalPortalService = internalPortalService;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.fieldManager = fieldManager;
        this.requestTypeInternalService = requestTypeInternalService;
        this.serviceDeskIssueTypeManager = serviceDeskIssueTypeManager;
        this.requestTypeEditFieldRenderer = requestTypeEditFieldRenderer;
    }

    public void setServiceDeskKey(String serviceDeskKey) {
        this.portalKeyOpt = io.atlassian.fugue.Option.option((Object)serviceDeskKey);
    }

    public void setRtId(Integer requestTypeId) {
        this.requestTypeIdOpt = io.atlassian.fugue.Option.option((Object)requestTypeId);
    }

    public void setFieldId(String fieldId) {
        this.fieldIdOpt = io.atlassian.fugue.Option.option((Object)fieldId);
    }

    public void setIsHideAction(boolean isHideAction) {
        this.isHideAction = isHideAction;
    }

    public String doDefault() throws Exception {
        return (String)this.retrieveEditFieldHtmlRenderer().fold(this::notFoundResult, renderResult -> this.actionView(() -> this.renderDialogValueTemplate((RequestTypeEditFieldRenderer.EditFieldRenderer)renderResult)));
    }

    protected String doExecute() throws Exception {
        return (String)this.retrieveEditFieldHtmlRenderer().fold(this::notFoundResult, renderResult -> {
            if (renderResult.hasAnyErrors()) {
                return this.actionView(() -> this.renderDialogValueTemplate((RequestTypeEditFieldRenderer.EditFieldRenderer)renderResult));
            }
            return this.returnComplete();
        });
    }

    private void renderDialogValueTemplate(RequestTypeEditFieldRenderer.EditFieldRenderer editFieldRenderer) {
        RequestTypeEditFieldRenderer.ActionWithErrorsApplied thisActionWithErrorsApplied = editFieldRenderer.applyErrorsToAction((ActionSupport)this);
        String editHtml = editFieldRenderer.renderEditFieldHtml(thisActionWithErrorsApplied);
        HttpServletRequest request = ActionContext.getRequest();
        ImmutableMap renderParams = ImmutableMap.builder().put((Object)"submitUrl", (Object)("FieldDefaultValues.jspa?" + request.getQueryString())).put((Object)"editHtml", (Object)editHtml).put((Object)"actionUrl", (Object)request.getRequestURI()).put((Object)"isHideAction", (Object)this.isHideAction).put((Object)"modifierKey", (Object)BrowserUtils.getModifierKey()).build();
        this.renderSoy("com.atlassian.servicedesk.project-ui:soy/ServiceDesk.Templates.Agent.Customer.defaultValueDialog", (Map<String, Object>)renderParams);
        this.setSuccessfulForMau();
    }

    private String notFoundResult() {
        try {
            ActionContext.getResponse().sendError(404);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private io.atlassian.fugue.Option<RequestTypeEditFieldRenderer.EditFieldRenderer> retrieveEditFieldHtmlRenderer() {
        return Steps.begin((io.atlassian.fugue.Option)StepsConverters.newerOption((Option)this.userFactory.getCheckedUser().toOption())).then(user -> this.retrieveOrderableField()).then((user, field) -> this.retrieveProjectOfPortal((CheckedUser)user)).then((user, field, project) -> this.retrieveIssueTypeFromRequestType((CheckedUser)user, (Project)project)).yield((user, field, project, issueType) -> this.retrieveEditFieldHtmlRenderer((Project)project, (IssueType)issueType, (OrderableField)field));
    }

    private RequestTypeEditFieldRenderer.EditFieldRenderer retrieveEditFieldHtmlRenderer(Project project, IssueType issueType, OrderableField field) {
        Map actionParams = ActionContext.getParameters();
        return this.requestTypeEditFieldRenderer.buildEditFieldRenderer(project, issueType, field, actionParams);
    }

    private io.atlassian.fugue.Option<OrderableField> retrieveOrderableField() {
        return Steps.begin(this.fieldIdOpt).then(fieldId -> io.atlassian.fugue.Option.option((Object)this.fieldManager.getOrderableField(fieldId))).yield((fieldId, orderableField) -> orderableField);
    }

    private io.atlassian.fugue.Option<IssueType> retrieveIssueTypeFromRequestType(CheckedUser user, Project project) {
        return Steps.begin(this.requestTypeIdOpt).then(requestTypeId -> this.requestTypeInternalService.getRequestTypeById(user, requestTypeId, project).toOption()).then((requestTypeId, requestType) -> this.serviceDeskIssueTypeManager.getIssueTypeForProject(requestType.getIssueTypeId(), project).toOption()).yield((requestTypeId, requestType, issueType) -> issueType);
    }

    private io.atlassian.fugue.Option<Project> retrieveProjectOfPortal(CheckedUser user) {
        return Steps.begin(this.portalKeyOpt).then(portalKey -> this.internalPortalService.getPortal(user, (String)portalKey).toOption()).then((portalKey, portal) -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(portal.getProjectId())).toOption()).yield((portalKey, portal, project) -> project);
    }
}

