/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.SyncUpgradeTask;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncUpgradeTaskUpdateCollaboratorRoleDescription
implements SyncUpgradeTask {
    private static final String COLLABORATOR_ROLE_NAME = "Service Desk Collaborators";
    private ProjectRoleManager projectRoleManager;
    private I18nHelper.BeanFactory i18nFactory;
    private ApplicationProperties applicationProperties;

    @Autowired
    public SyncUpgradeTaskUpdateCollaboratorRoleDescription(ProjectRoleManager projectRoleManager, I18nHelper.BeanFactory i18nFactory, ApplicationProperties applicationProperties) {
        this.projectRoleManager = projectRoleManager;
        this.i18nFactory = i18nFactory;
        this.applicationProperties = applicationProperties;
    }

    public String getVersionIntroduced() {
        return "3.0-OD-xx";
    }

    public void doUpgrade() {
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(COLLABORATOR_ROLE_NAME);
        if (projectRole != null) {
            I18nHelper systemI18n = this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
            String newDescription = systemI18n.getText("sd.role.create.description.collaborators.obsolete");
            ProjectRoleImpl updatedRole = new ProjectRoleImpl(projectRole.getId(), projectRole.getName(), newDescription);
            this.projectRoleManager.updateRole((ProjectRole)updatedRole);
        }
    }

    public String getVersionMigratedFromAsync() {
        return "3.2.0-OD-01";
    }

    public String getAsyncTaskName() {
        return "AsyncUpgradeTaskUpdateCollaboratorRoleDescription";
    }
}

