/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.tasks;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.stream.CloseableIterable;
import com.atlassian.servicedesk.internal.ao.schema.current.ServiceDeskDbSchema;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.SyncUpgradeTask;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricQStore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.querydsl.core.Tuple;
import io.atlassian.fugue.Unit;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class SyncUpgradeTaskMigrateTimeMetricsForSlaThresholds
implements SyncUpgradeTask {
    private static List<Long> SLA_THRESHOLD_REMAINING_TIMES_TO_BE_CREATED = Lists.newArrayList((Object[])new Long[]{Duration.standardMinutes((long)60L).getMillis(), Duration.standardMinutes((long)30L).getMillis(), Duration.ZERO.getMillis()});
    private final ActiveObjects ao;
    private final TimeMetricQStore timeMetricQStore;
    private final DatabaseAccessor databaseAccessor;
    private static final String TIME_METRIC_ID = "TIME_METRIC_ID";
    private static final String REMAINING_TIME = "REMAINING_TIME";

    public SyncUpgradeTaskMigrateTimeMetricsForSlaThresholds(ActiveObjects ao, TimeMetricQStore timeMetricQStore, DatabaseAccessor databaseAccessor) {
        this.ao = ao;
        this.timeMetricQStore = timeMetricQStore;
        this.databaseAccessor = databaseAccessor;
    }

    public String getVersionIntroduced() {
        return "2.2-OD-05";
    }

    public void doUpgrade() {
        Timestamp now = new Timestamp(DateTime.now().getMillis());
        this.databaseAccessor.run(conn -> {
            try (CloseableIterable<Tuple> timeMetricIterator = this.timeMetricQStore.streamTimeMetricsForSlaThresholdsUpgradeTask((DatabaseConnection)conn);){
                for (Tuple timeMetricTuple : timeMetricIterator) {
                    this.createDefaultThresholds(timeMetricTuple);
                    this.setThresholdConfigChangeDateToNow(timeMetricTuple, now);
                }
            }
            return Unit.Unit();
        });
    }

    public String getVersionMigratedFromAsync() {
        return "3.2.0-OD-01";
    }

    public String getAsyncTaskName() {
        return "AsyncUpgradeTaskMigrateTimeMetricsForSlaThresholds";
    }

    private void setThresholdConfigChangeDateToNow(Tuple timeMetricTuple, Timestamp now) {
        ServiceDeskDbSchema.TimeMetricAO timeMetricAO = (ServiceDeskDbSchema.TimeMetricAO)this.ao.get(ServiceDeskDbSchema.TimeMetricAO.class, timeMetricTuple.get(Tables.TIME_METRIC.ID));
        timeMetricAO.setThresholdsConfigChangeDate(now);
        timeMetricAO.save();
    }

    private void createDefaultThresholds(Tuple timeMetricTuple) {
        for (Long slaThresholdRemainingTime : SLA_THRESHOLD_REMAINING_TIMES_TO_BE_CREATED) {
            if (this.thresholdRemainingTimeAlreadyExists(timeMetricTuple, slaThresholdRemainingTime)) continue;
            this.ao.create(ServiceDeskDbSchema.SlaThresholdAO.class, this.getThresholdParamsForRemainingTime(timeMetricTuple, slaThresholdRemainingTime));
        }
    }

    private boolean thresholdRemainingTimeAlreadyExists(Tuple timeMetricTuple, Long slaThresholdRemainingTime) {
        ServiceDeskDbSchema.SlaThresholdAO[] result = (ServiceDeskDbSchema.SlaThresholdAO[])this.ao.find(ServiceDeskDbSchema.SlaThresholdAO.class, "TIME_METRIC_ID = ? AND REMAINING_TIME = ?", new Object[]{timeMetricTuple.get(Tables.TIME_METRIC.ID), slaThresholdRemainingTime});
        return result != null && result.length != 0;
    }

    private Map<String, Object> getThresholdParamsForRemainingTime(Tuple timeMetricTuple, Long remainingTime) {
        HashMap thresholdParams = Maps.newHashMap();
        thresholdParams.put(TIME_METRIC_ID, timeMetricTuple.get(Tables.TIME_METRIC.ID));
        thresholdParams.put(REMAINING_TIME, remainingTime);
        return thresholdParams;
    }
}

