/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.tasks;

import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.servicedesk.bootstrap.upgrade.helper.AsyncUpgradeTaskServiceDeskIssuesDbHelper;
import com.atlassian.servicedesk.bootstrap.upgrade.helper.VariableFrequencyProgressLogger;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.SyncUpgradeTask;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Option;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.log4j.Logger;

public class SyncUpgradeTaskMarkReporterCommentsAsPublic
implements SyncUpgradeTask {
    private static final String SD_COMMENT_PROPERTY_ENTITY_NAME = "sd.comment.property";
    private static final String JIRA_COMMENT_PROPERTY_ENTITY_NAME = EntityPropertyType.COMMENT_PROPERTY.getDbEntityName();
    private static final String SD_COMMENT_PROPERTY_NON_PUBLIC_KEY = "sd.public.comment";
    private static final String SD_COMMENT_PROPERTY_NON_PUBLIC_NAME = "internal";
    private static final CommentPropertyJsonEntry JIRA_INTERNAL_COMMENT_MARKER = new CommentPropertyJsonEntry(JIRA_COMMENT_PROPERTY_ENTITY_NAME, "sd.public.comment", "internal");
    private static final CommentPropertyJsonEntry SD_INTERNAL_COMMENT_MARKER = new CommentPropertyJsonEntry("sd.comment.property", "sd.public.comment", "internal");
    private Logger log = Logger.getLogger(SyncUpgradeTaskMarkReporterCommentsAsPublic.class);
    private CommentManager commentManager;
    private JsonEntityPropertyManager jsonEntityPropertyManager;
    private AsyncUpgradeTaskServiceDeskIssuesDbHelper upgradeHelper;
    private static final Function<Long, String> LOG_MESSAGE_BUILDER = upgradedIssues -> upgradedIssues + " issues successfully upgraded by " + SyncUpgradeTaskMarkReporterCommentsAsPublic.class.getSimpleName();

    public SyncUpgradeTaskMarkReporterCommentsAsPublic(CommentManager commentManager, JsonEntityPropertyManager jsonEntityPropertyManager, AsyncUpgradeTaskServiceDeskIssuesDbHelper upgradeHelper) {
        this.commentManager = commentManager;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.upgradeHelper = upgradeHelper;
    }

    public String getVersionIntroduced() {
        return "2.6.0-OD-01";
    }

    public void doUpgrade() {
        long startTimeMillis = System.currentTimeMillis();
        VariableFrequencyProgressLogger.VariableFrequencyProgressLoggerBuilder builder = new VariableFrequencyProgressLogger.VariableFrequencyProgressLoggerBuilder(this.log, LOG_MESSAGE_BUILDER);
        final VariableFrequencyProgressLogger progressLogger = builder.withLogFrequencyRange(0L, 100L).withLogFrequencyRange(1000L, 1000L).build();
        Effect<Issue> upgradeIssueFunction = new Effect<Issue>(){

            public void apply(Issue issue) {
                SyncUpgradeTaskMarkReporterCommentsAsPublic.this.upgradeCommentsForIssue(issue);
                progressLogger.onUpgradeProgress();
            }
        };
        this.upgradeHelper.applyEffectForAllServiceDeskIssues(upgradeIssueFunction);
        long timeTakenMillis = System.currentTimeMillis() - startTimeMillis;
        this.log.info((Object)this.buildSuccessMessage(timeTakenMillis));
    }

    public String getVersionMigratedFromAsync() {
        return "3.1-OD-13";
    }

    public String getAsyncTaskName() {
        return "AsyncUpgradeTaskMarkReporterCommentsAsPublic";
    }

    private String buildSuccessMessage(long timeTakenMillis) {
        long timeSeconds = timeTakenMillis / 1000L;
        return "Successfully completed " + this.getClass().getSimpleName() + " after " + timeSeconds + " seconds.";
    }

    @VisibleForTesting
    protected void upgradeCommentsForIssue(Issue issue) {
        for (ApplicationUser reporter : Option.option((Object)issue.getReporter())) {
            for (Comment comment : this.commentManager.getComments(issue)) {
                if (!this.shouldConvertToPublic(comment, reporter)) continue;
                this.markAsPublic(comment);
            }
        }
    }

    @VisibleForTesting
    protected boolean shouldConvertToPublic(Comment comment, ApplicationUser issueReporter) {
        return this.commentAuthorEquals(comment, issueReporter) && this.commentIsMarkedInternal(comment);
    }

    private boolean commentAuthorEquals(Comment comment, ApplicationUser applicationUser) {
        Iterator iterator = Option.option((Object)comment.getAuthorApplicationUser()).iterator();
        if (iterator.hasNext()) {
            ApplicationUser commentAuthor = (ApplicationUser)iterator.next();
            return commentAuthor.equals((Object)applicationUser);
        }
        return false;
    }

    private boolean commentIsMarkedInternal(Comment comment) {
        return (Boolean)this.getCommentPropertyBoolean(comment, SD_INTERNAL_COMMENT_MARKER).getOrElse((Object)false);
    }

    private Option<Boolean> getCommentPropertyBoolean(Comment comment, CommentPropertyJsonEntry commentPropertyEntry) {
        try {
            Iterator iterator = this.getCommentPropertyJson(comment, commentPropertyEntry).iterator();
            if (iterator.hasNext()) {
                JSONObject json = (JSONObject)iterator.next();
                if (json.has(commentPropertyEntry.jsonPropertyName)) {
                    return Option.some((Object)json.getBoolean(commentPropertyEntry.jsonPropertyName));
                }
                return Option.none();
            }
            return Option.none();
        }
        catch (JSONException ex) {
            this.log.error((Object)("Error reading comment property '" + commentPropertyEntry.propertyKey + "' for comment ID '" + comment.getId() + "'. Expected '" + commentPropertyEntry.jsonPropertyName + "' to be a boolean"));
            return Option.none();
        }
    }

    private Option<JSONObject> getCommentPropertyJson(Comment comment, CommentPropertyJsonEntry commentPropertyEntry) {
        Option entityPropertyOption = Option.option((Object)this.jsonEntityPropertyManager.get(commentPropertyEntry.entityName, comment.getId(), commentPropertyEntry.propertyKey));
        if (entityPropertyOption.isEmpty()) {
            return Option.none();
        }
        EntityProperty entityProperty = (EntityProperty)entityPropertyOption.get();
        try {
            JSONObject json = new JSONObject(entityProperty.getValue());
            return Option.some((Object)json);
        }
        catch (JSONException ex) {
            this.log.error((Object)("Comment property '" + commentPropertyEntry.propertyKey + "' for comment ID '" + comment.getId() + "' is corrupt and not valid JSON"));
            return Option.none();
        }
    }

    @VisibleForTesting
    protected void markAsPublic(Comment comment) {
        this.updateCommentPropertyBooleanEntryIfPresent(comment, JIRA_INTERNAL_COMMENT_MARKER, false);
        this.updateCommentPropertyBooleanEntryIfPresent(comment, SD_INTERNAL_COMMENT_MARKER, false);
    }

    private void updateCommentPropertyBooleanEntryIfPresent(Comment comment, CommentPropertyJsonEntry commentPropertyEntry, boolean newBooleanValue) {
        try {
            for (JSONObject propertyJson : this.getCommentPropertyJson(comment, commentPropertyEntry)) {
                if (!propertyJson.has(commentPropertyEntry.jsonPropertyName)) continue;
                propertyJson.put(commentPropertyEntry.jsonPropertyName, newBooleanValue);
                this.writeCommentProperty(comment, commentPropertyEntry, propertyJson);
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeCommentProperty(Comment comment, CommentPropertyJsonEntry commentPropertyEntry, JSONObject newJson) {
        this.jsonEntityPropertyManager.put(null, commentPropertyEntry.entityName, comment.getId(), commentPropertyEntry.propertyKey, newJson.toString(), (BiFunction)null, false);
    }

    protected static class CommentPropertyJsonEntry {
        public final String entityName;
        public final String propertyKey;
        public final String jsonPropertyName;

        public CommentPropertyJsonEntry(String entityName, String propertyKey, String jsonPropertyName) {
            this.entityName = entityName;
            this.propertyKey = propertyKey;
            this.jsonPropertyName = jsonPropertyName;
        }
    }
}

