/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.tasks;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.bootstrap.upgrade.helper.AsyncUpgradeTaskServiceDeskIssuesDbHelper;
import com.atlassian.servicedesk.bootstrap.upgrade.helper.VariableFrequencyProgressLogger;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.SyncUpgradeTask;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Options;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public class SyncUpgradeTaskFixOldStyleRequestChannelIssueProperties
implements SyncUpgradeTask {
    private static final String SD_REQUEST_CHANNEL_KEY = "request.channel.type";
    private static final String SD_REQUEST_EMAIL_CHANNEL_SOURCE_KEY = "request.channel.email.source";
    private static final Set<String> KEYS_TO_UPDATE = ImmutableSet.of((Object)"request.channel.type", (Object)"request.channel.email.source");
    private static final String PROPERTY_PATH_KEY = "value";
    private static final EntityPropertyOptions ENTITY_PROPERTY_OPTIONS = new EntityPropertyOptions.Builder().skipPermissionChecks().build();
    private static final Logger log = Logger.getLogger(SyncUpgradeTaskFixOldStyleRequestChannelIssueProperties.class);
    private static final Function<EntityPropertyService.PropertyResult, io.atlassian.fugue.Option<EntityProperty>> GET_ENTITY_PROPERTY_FUNCTION = propertyResult -> StepsConverters.newerOption((Option)propertyResult.getEntityProperty());
    private static final Predicate<EntityProperty> ENTITY_PROPERTY_JSON_FILTER_PREDICATE = input -> {
        String value = input.getValue();
        try {
            new JSONObject(value);
            return false;
        }
        catch (JSONException e) {
            return true;
        }
    };
    private static final Function<Long, String> LOG_MESSAGE_BUILDER = upgradedIssues -> upgradedIssues + " issues successfully upgraded by " + SyncUpgradeTaskFixOldStyleRequestChannelIssueProperties.class.getSimpleName();
    private final IssuePropertyService issuePropertyService;
    private final AsyncUpgradeTaskServiceDeskIssuesDbHelper upgradeHelper;

    public SyncUpgradeTaskFixOldStyleRequestChannelIssueProperties(IssuePropertyService issuePropertyService, AsyncUpgradeTaskServiceDeskIssuesDbHelper upgradeHelper) {
        this.issuePropertyService = issuePropertyService;
        this.upgradeHelper = upgradeHelper;
    }

    public String getVersionIntroduced() {
        return "2.6.0-OD-01";
    }

    public void doUpgrade() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        VariableFrequencyProgressLogger.VariableFrequencyProgressLoggerBuilder builder = new VariableFrequencyProgressLogger.VariableFrequencyProgressLoggerBuilder(log, LOG_MESSAGE_BUILDER);
        VariableFrequencyProgressLogger progressLogger = builder.withLogFrequencyRange(0L, 100L).withLogFrequencyRange(1000L, 1000L).build();
        Effect upgradeIssueFunction = issue -> {
            this.upgradeIssueProperties((Issue)issue);
            progressLogger.onUpgradeProgress();
        };
        this.upgradeHelper.applyEffectForAllServiceDeskIssues((Effect<Issue>)upgradeIssueFunction);
        stopWatch.stop();
        long taskDuration = TimeUnit.SECONDS.convert(stopWatch.getTime(), TimeUnit.MILLISECONDS);
        log.info((Object)this.buildSuccessMessage(taskDuration));
    }

    public String getVersionMigratedFromAsync() {
        return "3.2.0-OD-01";
    }

    public String getAsyncTaskName() {
        return "AsyncUpgradeTaskFixOldStyleRequestChannelIssueProperties";
    }

    private String buildSuccessMessage(long timeTakenSeconds) {
        return "Successfully completed " + this.getClass().getSimpleName() + " after " + timeTakenSeconds + " seconds.";
    }

    private io.atlassian.fugue.Option<EntityProperty> extractPropertiesToUpdate(Long issueId, String propertyKey) {
        return io.atlassian.fugue.Option.option((Object)this.issuePropertyService.getProperty(null, issueId, propertyKey, ENTITY_PROPERTY_OPTIONS)).flatMap(GET_ENTITY_PROPERTY_FUNCTION).filter(ENTITY_PROPERTY_JSON_FILTER_PREDICATE);
    }

    @VisibleForTesting
    protected void upgradeIssueProperties(Issue issue) {
        Long issueId = issue.getId();
        Iterable properties = Options.flatten((Iterable)Collections2.transform(KEYS_TO_UPDATE, input -> this.extractPropertiesToUpdate(issueId, (String)input)));
        for (EntityProperty entityProperty : properties) {
            JSONObject jsObject = new JSONObject(Collections.singletonMap(PROPERTY_PATH_KEY, StringUtils.strip((String)entityProperty.getValue(), (String)"\"")));
            EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput(jsObject.toString(), entityProperty.getKey());
            EntityPropertyService.SetPropertyValidationResult validationResult = this.issuePropertyService.validateSetProperty(null, issueId, propertyInput, ENTITY_PROPERTY_OPTIONS);
            this.issuePropertyService.setProperty(null, validationResult);
        }
    }
}

