/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.tasks;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.customfields.service.FieldLockingService;
import com.atlassian.pocketknife.api.logging.LoggingSupport;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTask;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTaskResult;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.HashSet;

public class AsyncUpgradeTaskLockVpOriginField
implements AsyncUpgradeTask {
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final FieldLayoutManager fieldLayoutManager;
    private final FieldLockingService fieldLockingService;
    private final ProjectManager projectManager;
    private final LoggingSupport loggingSupport;
    private final I18nHelper i18nHelper;
    private final CustomFieldManager customFieldManager;

    public AsyncUpgradeTaskLockVpOriginField(VpOriginCustomFieldService vpOriginCustomFieldService, FieldLayoutManager fieldLayoutManager, FieldLockingService fieldLockingService, ProjectManager projectManager, LoggingSupport loggingSupport, I18nHelper i18nHelper, CustomFieldManager customFieldManager) {
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldLockingService = fieldLockingService;
        this.projectManager = projectManager;
        this.loggingSupport = loggingSupport;
        this.i18nHelper = i18nHelper;
        this.customFieldManager = customFieldManager;
    }

    public int getBuildNumber() {
        return 3;
    }

    public String getVersionIntroduced() {
        return "2.4-OD-05";
    }

    public AsyncUpgradeTaskResult doUpgrade() {
        Option vpOriginCustomFieldOpt = Option.option((Object)this.vpOriginCustomFieldService.getVpOriginCustomField());
        if (vpOriginCustomFieldOpt.isDefined()) {
            CustomField vpOriginCustomField = (CustomField)vpOriginCustomFieldOpt.get();
            if (this.fieldLockingService.isFieldLocked(vpOriginCustomField)) {
                return AsyncUpgradeTaskResult.success((String)"Do not need to run as VpOrigin custom field is locked already");
            }
            this.loggingSupport.log().info("Updating custom field description");
            this.customFieldManager.updateCustomField(vpOriginCustomField.getIdAsLong(), vpOriginCustomField.getName(), this.i18nHelper.getText("sd.origin.customfield.desc"), vpOriginCustomField.getCustomFieldSearcher());
            HashSet fieldLayouts = Sets.newHashSet();
            for (Project project : this.projectManager.getProjectObjects()) {
                for (IssueType issueType : project.getIssueTypes()) {
                    FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(project, issueType.getId());
                    EditableFieldLayout editableFieldLayout = this.fieldLayoutManager.getEditableFieldLayout(fieldLayout.getId());
                    fieldLayouts.add(editableFieldLayout);
                }
            }
            this.loggingSupport.log().info("Ensuring VpOrigin custom field is shown on {} field layouts for all projects, as well as the default", (Object)fieldLayouts.size());
            fieldLayouts.add(this.fieldLayoutManager.getEditableDefaultFieldLayout());
            for (EditableFieldLayout layout : fieldLayouts) {
                this.showCustomFieldIfHidden(layout, vpOriginCustomField);
            }
            this.loggingSupport.log().info("Locking the VpOrigin custom field");
            ErrorCollection lockResult = this.fieldLockingService.lockField(vpOriginCustomField, "sd.origin.customfield.locked.desc");
            if (lockResult.hasAnyErrors()) {
                return AsyncUpgradeTaskResult.failure((String)("Failed to lock VpOrigin custom field : " + lockResult));
            }
            return AsyncUpgradeTaskResult.success();
        }
        return AsyncUpgradeTaskResult.failure((String)"Could not find the VpOrigin customfield");
    }

    private void showCustomFieldIfHidden(EditableFieldLayout layout, CustomField vpOriginCustomField) {
        if (layout.isFieldHidden(vpOriginCustomField.getId())) {
            this.loggingSupport.log().info("Showing vpOrigin custom field on field layout : id = {}, name = {}", (Object)layout.getId(), (Object)layout.getName());
            FieldLayoutItem vpFieldLayoutItem = layout.getFieldLayoutItem((OrderableField)vpOriginCustomField);
            layout.show(vpFieldLayoutItem);
            if (EditableDefaultFieldLayout.class.isAssignableFrom(layout.getClass())) {
                this.fieldLayoutManager.storeEditableDefaultFieldLayout((EditableDefaultFieldLayout)layout);
            } else {
                this.fieldLayoutManager.storeEditableFieldLayout(layout);
            }
        }
    }
}

