/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.registry;

import com.atlassian.pocketknife.api.autowire.PluginAutowirer;
import com.atlassian.servicedesk.bootstrap.upgrade.registry.UpgradeTaskReference;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.JSDUpgradeTask;
import com.atlassian.util.concurrent.LazyReference;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;

public final class UpgradeTaskRegistry<T extends JSDUpgradeTask> {
    private final List<UpgradeTaskReference<? extends T>> references;
    private final PluginAutowirer pluginAutowirer;
    private final BundleContext bundleContext;
    private final LazyReference<List<T>> upgradeTasks = new LazyReference<List<T>>(){

        protected List<T> create() throws Exception {
            return UpgradeTaskRegistry.this.getOrCreateUpgradeTaskInstances(UpgradeTaskRegistry.this.references, UpgradeTaskRegistry.this.pluginAutowirer, UpgradeTaskRegistry.this.bundleContext);
        }
    };

    public UpgradeTaskRegistry(List<UpgradeTaskReference<? extends T>> references, PluginAutowirer pluginAutowirer, BundleContext bundleContext) {
        this.references = references;
        this.pluginAutowirer = pluginAutowirer;
        this.bundleContext = bundleContext;
    }

    private List<T> getOrCreateUpgradeTaskInstances(List<UpgradeTaskReference<? extends T>> references, PluginAutowirer pluginAutowirer, BundleContext bundleContext) {
        return Collections.unmodifiableList(references.stream().map(ref -> ref.getInstance(pluginAutowirer, bundleContext)).collect(Collectors.toList()));
    }

    public List<T> getAll() {
        return (List)this.upgradeTasks.get();
    }

    public Option<T> getByClassName(String className) {
        return Option.fromOptional(((List)this.upgradeTasks.get()).stream().filter(ut -> ut.getClass().getSimpleName().equals(className)).findFirst());
    }
}

