/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.helper;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.pocketknife.api.logging.LoggingSupport;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddCustomFieldToScreensHelper {
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final ProjectManager projectManager;
    private final LoggingSupport loggingSupport;

    @Autowired
    public AddCustomFieldToScreensHelper(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, ServiceDeskInternalManager serviceDeskManager, ProjectManager projectManager, LoggingSupport loggingSupport) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.serviceDeskManager = serviceDeskManager;
        this.projectManager = projectManager;
        this.loggingSupport = loggingSupport;
    }

    public void addCustomFieldToScreens(CustomField customField) {
        for (ServiceDesk sd : this.serviceDeskManager.getAllServiceDesks()) {
            Project project = this.projectManager.getProjectObj(Long.valueOf(sd.getProjectId()));
            this.loggingSupport.log().info("Adding custom field " + customField.getFieldName() + " to screens on project " + project.getKey());
            IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project);
            for (IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity : issueTypeScreenScheme.getEntities()) {
                FieldScreenScheme fieldScreenScheme = issueTypeScreenSchemeEntity.getFieldScreenScheme();
                for (FieldScreenSchemeItem fieldScreenSchemeItem : fieldScreenScheme.getFieldScreenSchemeItems()) {
                    List tabs;
                    FieldScreen fieldScreen = fieldScreenSchemeItem.getFieldScreen();
                    if (fieldScreen.containsField(customField.getId()) || (tabs = fieldScreen.getTabs()).isEmpty()) continue;
                    FieldScreenTab fieldScreenTab = (FieldScreenTab)tabs.get(0);
                    this.loggingSupport.log().info("Adding custom field " + customField.getFieldName() + " to screen: " + fieldScreen.getName());
                    fieldScreenTab.addFieldScreenLayoutItem(customField.getId());
                }
            }
        }
    }
}

