/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.bootstrap.upgrade.SyncUpgradeTaskRecordStore;
import com.atlassian.servicedesk.bootstrap.version.BuildProperties;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.SyncUpgradeTask;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class SyncUpgradeTaskRecordStoreImpl
implements SyncUpgradeTaskRecordStore {
    private static final String STARTED = "STARTED";
    private static final String COMPLETED = "COMPLETED";
    private static final String FAILED = "FAILED";
    private final BuildProperties buildProperties;
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public SyncUpgradeTaskRecordStoreImpl(BuildProperties buildProperties, DatabaseAccessor databaseAccessor) {
        this.buildProperties = buildProperties;
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public boolean hasTaskCompleted(Class<? extends SyncUpgradeTask> taskClazz) {
        return (Boolean)this.databaseAccessor.run(conn -> (Long)((SQLQuery)((SQLQuery)conn.select((Expression)Tables.SYNC_UPGRADE_RECORD.ID.count()).from((Expression)Tables.SYNC_UPGRADE_RECORD)).where((Predicate)Tables.SYNC_UPGRADE_RECORD.UPGRADE_TASK_NAME.eq((Object)taskClazz.getSimpleName()).and((Predicate)Tables.SYNC_UPGRADE_RECORD.ACTION.eq((Object)COMPLETED)))).fetchOne() >= 1L);
    }

    @Override
    public void writeStartRecord(Class<? extends SyncUpgradeTask> taskClazz) {
        this.writeRecord(STARTED, "", "", taskClazz);
    }

    @Override
    public void writeFailureRecord(Class<? extends SyncUpgradeTask> taskClazz, Option<String> failureMessage, Option<String> exception) {
        this.writeRecord(FAILED, (String)exception.getOrElse((Object)""), (String)failureMessage.getOrElse((Object)""), taskClazz);
    }

    @Override
    public void writeCompleteRecord(Class<? extends SyncUpgradeTask> taskClazz) {
        this.writeRecord(COMPLETED, "", "", taskClazz);
    }

    private void writeRecord(String action, String exception, String message, Class<? extends SyncUpgradeTask> taskClazz) {
        Integer id = (Integer)this.databaseAccessor.runInTransaction(conn -> (Integer)conn.insert((RelationalPath)Tables.SYNC_UPGRADE_RECORD).set((Path)Tables.SYNC_UPGRADE_RECORD.ACTION, (Object)action).set(Tables.SYNC_UPGRADE_RECORD.CREATED_DATE, (Object)new Timestamp(System.currentTimeMillis())).set((Path)Tables.SYNC_UPGRADE_RECORD.EXCEPTION, (Object)exception).set((Path)Tables.SYNC_UPGRADE_RECORD.MESSAGE, (Object)message).set((Path)Tables.SYNC_UPGRADE_RECORD.SERVICE_DESK_VERSION, (Object)this.buildProperties.getVersion()).set((Path)Tables.SYNC_UPGRADE_RECORD.UPGRADE_TASK_NAME, (Object)taskClazz.getSimpleName()).executeWithKey(Tables.SYNC_UPGRADE_RECORD.ID));
        Assert.isTrue((id != null ? 1 : 0) != 0, (String)"Cannot find the new id for newly inserted row");
    }
}

