/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade;

import com.atlassian.pocketknife.internal.logging.LoggingUtil;
import com.atlassian.servicedesk.bootstrap.upgrade.AsyncUpgradeTaskRegistration;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTask;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTaskOutcome;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTaskResult;
import com.atlassian.servicedesk.internal.upgrade.AsyncUpgradeTaskRecordQStore;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.atlassian.upgrade.spi.UpgradeTaskFactory;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceDeskUpgradeTaskFactory
implements UpgradeTaskFactory {
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskUpgradeTaskFactory.class);
    private final AsyncUpgradeTaskRegistration asyncUpgradeTaskRegistration;
    private final AsyncUpgradeTaskRecordQStore asyncUpgradeTaskRecordQStore;

    public ServiceDeskUpgradeTaskFactory(AsyncUpgradeTaskRegistration asyncUpgradeTaskRegistration, AsyncUpgradeTaskRecordQStore asyncUpgradeTaskRecordQStore) {
        this.asyncUpgradeTaskRegistration = asyncUpgradeTaskRegistration;
        this.asyncUpgradeTaskRecordQStore = asyncUpgradeTaskRecordQStore;
        LoggingUtil.setLevelToInfoIfNotDefined(log);
    }

    public String getProductDisplayName() {
        return "JIRA Service Desk";
    }

    public String getProductMinimumVersion() {
        return "3.0.0";
    }

    public int getMinimumBuildNumber() {
        return 0;
    }

    @Nonnull
    public Collection<UpgradeTask> getAllUpgradeTasks() {
        if (!this.asyncUpgradeTaskRegistration.buildNumbersAreUnique()) {
            throw new IllegalStateException("UpgradeTask must have unique buildNumber");
        }
        log.info("Converting JSD Async Upgrade tasks to the Upgrade Task Framework format.");
        return this.asyncUpgradeTaskRegistration.getAsyncUpgradeTasks().stream().map(x$0 -> new AsyncUpgradeTaskAdapter((AsyncUpgradeTask)x$0)).collect(Collectors.toList());
    }

    private final class AsyncUpgradeTaskAdapter
    implements UpgradeTask {
        private final AsyncUpgradeTask upgradeTask;
        private final Logger log;

        private AsyncUpgradeTaskAdapter(AsyncUpgradeTask upgradeTask) {
            this.upgradeTask = upgradeTask;
            this.log = LoggerFactory.getLogger(upgradeTask.getClass());
            LoggingUtil.setLevelToInfoIfNotDefined(this.log);
        }

        public int getBuildNumber() {
            return this.upgradeTask.getBuildNumber();
        }

        public String getShortDescription() {
            return this.upgradeTask.getShortDescription();
        }

        public void runUpgrade(UpgradeContext upgradeContext) {
            Class<?> upgradeTaskClass = this.upgradeTask.getClass();
            if (ServiceDeskUpgradeTaskFactory.this.asyncUpgradeTaskRecordQStore.hasTaskCompleted(upgradeTaskClass)) {
                this.log.info(String.format("Upgrade task '%s' has already run, skipping.", upgradeTaskClass));
                return;
            }
            this.logUpgradeTaskStart(upgradeTaskClass);
            ServiceDeskUpgradeTaskFactory.this.asyncUpgradeTaskRecordQStore.writeStartRecord(upgradeTaskClass);
            AsyncUpgradeTaskResult result = this.upgradeTask.doUpgrade();
            if (result.getOutcome() != AsyncUpgradeTaskOutcome.SUCCEEDED) {
                String errorMessage = this.generateUpgradeTaskErrorMessage(upgradeTaskClass, result);
                this.log.error(errorMessage);
                ServiceDeskUpgradeTaskFactory.this.asyncUpgradeTaskRecordQStore.writeFailureRecord(upgradeTaskClass, (Option<String>)result.getMessage(), (Option<String>)Option.none());
                throw new RuntimeException(errorMessage);
            }
            this.log.info(String.format("Upgrade task '%s' applied successfully", upgradeTaskClass));
            ServiceDeskUpgradeTaskFactory.this.asyncUpgradeTaskRecordQStore.writeCompleteRecord(upgradeTaskClass, result);
        }

        private void logUpgradeTaskStart(Class<? extends AsyncUpgradeTask> upgradeTaskClass) {
            this.log.info(String.format("Starting upgrade task '%s' (%s), build number: %d", upgradeTaskClass.getSimpleName(), this.upgradeTask.getShortDescription(), this.upgradeTask.getBuildNumber()));
        }

        private String generateUpgradeTaskErrorMessage(Class<? extends AsyncUpgradeTask> upgradeTaskClass, AsyncUpgradeTaskResult result) {
            AsyncUpgradeTaskOutcome outcome = result.getOutcome();
            return (String)result.getMessage().fold(() -> String.format("Upgrade task '%s' failed with outcome '%s'", upgradeTaskClass, outcome), msg -> String.format("Upgrade task '%s' failed with with outcome '%s': %s", upgradeTaskClass, outcome, msg));
        }
    }
}

