/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.plugins.workinghours.api.calendar.event.CalendarDeletedEvent;
import com.atlassian.jira.plugins.workinghours.api.calendar.event.CalendarUpdatedEvent;
import com.atlassian.servicedesk.internal.analytics.IssueEventAnalyticsListener;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.atlassian.servicedesk.internal.cache.CacheClearer;
import com.atlassian.servicedesk.internal.comment.CommentEventListener;
import com.atlassian.servicedesk.internal.comment.event.ServiceDeskCommentEventPublisher;
import com.atlassian.servicedesk.internal.feature.customer.request.listener.RequestActivityIssueListener;
import com.atlassian.servicedesk.internal.feature.organization.event.OrganisationsAddedToIssueEventPublisher;
import com.atlassian.servicedesk.internal.feature.queue.ProjectStateCacheManager;
import com.atlassian.servicedesk.internal.issue.ServiceDeskIssueEventEmailNotifier;
import com.atlassian.servicedesk.internal.issue.listeners.IssueInitialFieldSetStateListener;
import com.atlassian.servicedesk.internal.issue.listeners.IssuePropertiesIssueEventListener;
import com.atlassian.servicedesk.internal.listener.CalendarEventListener;
import com.atlassian.servicedesk.internal.listener.ProjectEventListener;
import com.atlassian.servicedesk.internal.sla.listener.SlaCycleUpdater;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventListenerLauncher {
    private final CalendarEventListener calendarEventListener;
    private final SlaCycleUpdater slaCycleUpdater;
    private final CommentEventListener commentEventListener;
    private final ServiceDeskIssueEventEmailNotifier serviceDeskIssueEventEmailNotifier;
    private final ProjectEventListener projectEventListener;
    private final RequestActivityIssueListener requestActivityIssueListener;
    private final ServiceDeskCommentEventPublisher serviceDeskCommentEventPublisher;
    private final IssueEventAnalyticsListener issueEventAnalyticsListener;
    private final ProjectStateCacheManager projectStateCacheManager;
    private final IssuePropertiesIssueEventListener issuePropertiesIssueEventListener;
    private final CacheClearer cacheClearer;
    private final IssueEventHelper issueEventUtil;
    private final FeatureManager featureManager;
    private final OrganisationsAddedToIssueEventPublisher organisationsAddedToIssueEventPublisher;
    private final IssueInitialFieldSetStateListener issueInitialFieldSetStateListener;

    @Autowired
    public EventListenerLauncher(CalendarEventListener calendarEventListener, SlaCycleUpdater slaCycleUpdater, CommentEventListener commentEventListener, ServiceDeskIssueEventEmailNotifier serviceDeskIssueEventEmailNotifier, ProjectEventListener projectEventListener, RequestActivityIssueListener requestActivityIssueListener, ServiceDeskCommentEventPublisher serviceDeskCommentEventPublisher, IssueEventAnalyticsListener issueEventAnalyticsListener, ProjectStateCacheManager projectStateCacheManager, IssuePropertiesIssueEventListener issuePropertiesIssueEventListener, CacheClearer cacheClearer, IssueEventHelper issueEventUtil, FeatureManager featureManager, OrganisationsAddedToIssueEventPublisher organisationsAddedToIssueEventPublisher, IssueInitialFieldSetStateListener issueInitialFieldSetStateListener) {
        this.calendarEventListener = calendarEventListener;
        this.slaCycleUpdater = slaCycleUpdater;
        this.commentEventListener = commentEventListener;
        this.serviceDeskIssueEventEmailNotifier = serviceDeskIssueEventEmailNotifier;
        this.projectEventListener = projectEventListener;
        this.requestActivityIssueListener = requestActivityIssueListener;
        this.serviceDeskCommentEventPublisher = serviceDeskCommentEventPublisher;
        this.issueEventAnalyticsListener = issueEventAnalyticsListener;
        this.projectStateCacheManager = projectStateCacheManager;
        this.issuePropertiesIssueEventListener = issuePropertiesIssueEventListener;
        this.cacheClearer = cacheClearer;
        this.issueEventUtil = issueEventUtil;
        this.featureManager = featureManager;
        this.organisationsAddedToIssueEventPublisher = organisationsAddedToIssueEventPublisher;
        this.issueInitialFieldSetStateListener = issueInitialFieldSetStateListener;
    }

    @EventListener
    public void onIssueEvent(IssueEvent issueEvent) {
        this.commentEventListener.onIssueEvent(issueEvent);
        if (this.isRelevantIssueEvent(issueEvent)) {
            this.issuePropertiesIssueEventListener.onIssueEvent(issueEvent);
            this.issueInitialFieldSetStateListener.onIssueEvent(issueEvent);
            this.slaCycleUpdater.onIssueEvent(issueEvent);
            this.organisationsAddedToIssueEventPublisher.onIssueCreatedEvent(issueEvent);
            if (this.shouldSendConversationalNotifications()) {
                this.serviceDeskIssueEventEmailNotifier.onIssueEvent(issueEvent);
            }
            this.requestActivityIssueListener.onIssueActivityUpdate(issueEvent);
            this.issueEventAnalyticsListener.onIssueEvent(issueEvent);
            this.projectStateCacheManager.onIssueEvent(issueEvent);
        }
    }

    @EventListener
    public void onIssueChangedEvent(IssueChangedEvent issueChangedEvent) {
        this.commentEventListener.onIssueChangedEvent(issueChangedEvent);
        if (!this.isHandledByCommentCreatedEvent(issueChangedEvent)) {
            this.slaCycleUpdater.onIssueChangedEvent(issueChangedEvent);
            this.serviceDeskCommentEventPublisher.onIssueChangedEvent(issueChangedEvent);
            if (this.shouldSendConversationalNotifications()) {
                this.serviceDeskIssueEventEmailNotifier.onIssueChangedEvent(issueChangedEvent);
            }
            this.requestActivityIssueListener.onIssueChangedEvent(issueChangedEvent);
            this.issueEventAnalyticsListener.onIssueChangedEvent(issueChangedEvent);
            this.projectStateCacheManager.onIssueChangedEvent(issueChangedEvent);
        }
        this.organisationsAddedToIssueEventPublisher.onIssueChangedEvent(issueChangedEvent);
    }

    @EventListener
    public void onCommentCreatedEvent(CommentCreatedEvent commentCreatedEvent) {
        this.commentEventListener.onCommentCreatedEvent(commentCreatedEvent);
        this.slaCycleUpdater.onCommentCreatedEvent(commentCreatedEvent);
        this.serviceDeskCommentEventPublisher.onCommentCreatedEvent(commentCreatedEvent);
        if (this.shouldSendConversationalNotifications()) {
            this.serviceDeskIssueEventEmailNotifier.onCommentCreatedEvent(commentCreatedEvent);
        }
        this.requestActivityIssueListener.onCommentCreatedEvent(commentCreatedEvent);
        this.issueEventAnalyticsListener.onCommentCreatedEvent(commentCreatedEvent);
        this.projectStateCacheManager.onCommentCreatedEvent(commentCreatedEvent);
    }

    @EventListener
    public void onCommentUpdatedEvent(CommentUpdatedEvent commentUpdatedEvent) {
        this.commentEventListener.onCommentUpdatedEvent(commentUpdatedEvent);
        this.serviceDeskCommentEventPublisher.onCommentUpdatedEvent(commentUpdatedEvent);
        if (this.shouldSendConversationalNotifications()) {
            this.serviceDeskIssueEventEmailNotifier.onCommentUpdatedEvent(commentUpdatedEvent);
        }
        this.requestActivityIssueListener.onCommentUpdatedEvent(commentUpdatedEvent);
        this.issueEventAnalyticsListener.onCommentUpdatedEvent(commentUpdatedEvent);
        this.projectStateCacheManager.onCommentUpdatedEvent(commentUpdatedEvent);
    }

    @EventListener
    public void onCommentDeletedEvent(CommentDeletedEvent commentDeletedEvent) {
        this.requestActivityIssueListener.onCommentDeletedEvent(commentDeletedEvent);
        this.issueEventAnalyticsListener.onCommentDeletedEvent(commentDeletedEvent);
        this.projectStateCacheManager.onCommentDeletedEvent(commentDeletedEvent);
    }

    @EventListener
    public void onProjectCreate(ProjectCreatedEvent createProjectEvent) {
        this.projectEventListener.onProjectCreate(createProjectEvent);
    }

    @EventListener
    public void onProjectDelete(ProjectDeletedEvent deleteProjectEvent) {
        this.projectEventListener.onProjectDelete(deleteProjectEvent);
    }

    @EventListener
    public void onCalendarDeleted(CalendarDeletedEvent calendarEvent) {
        this.calendarEventListener.onCalendarDeleted(calendarEvent);
    }

    @EventListener
    public void onCalendarUpdated(CalendarUpdatedEvent calendarEvent) {
        this.calendarEventListener.onCalendarUpdated(calendarEvent);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        this.cacheClearer.onClearCache(clearCacheEvent);
    }

    private boolean isRelevantIssueEvent(IssueEvent event) {
        return this.issueEventUtil.isCreatedEvent(event) || this.issueEventUtil.isDeletedEvent(event);
    }

    private boolean isHandledByCommentCreatedEvent(IssueChangedEvent event) {
        Collection changeItemBeans = event.getChangeItems();
        boolean isCommentInEvent = event.getComment().isPresent();
        boolean onlyAttachmentsChanged = changeItemBeans.stream().allMatch(changeItem -> "attachment".equalsIgnoreCase(changeItem.getField()));
        return isCommentInEvent && onlyAttachmentsChanged;
    }

    @VisibleForTesting
    boolean shouldSendConversationalNotifications() {
        return !this.featureManager.isEnabled("sd.custom.email.notifications.cut.over");
    }
}

