/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.lifecycle.server;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.project.ProjectCreateHandler;
import com.atlassian.jira.project.ProjectCreateRegistrar;
import com.atlassian.jira.project.type.ProjectTypeUpdatedHandler;
import com.atlassian.jira.project.type.ProjectTypeUpdatedRegistrar;
import com.atlassian.pocketknife.api.ao.ActiveObjectInitialisationException;
import com.atlassian.pocketknife.api.ao.ActiveObjectsController;
import com.atlassian.pocketknife.api.logging.LoggingSupport;
import com.atlassian.pocketknife.api.logging.SupportInfo;
import com.atlassian.pocketknife.api.tracker.InvariantModuleTracker;
import com.atlassian.pocketknife.api.upgrade.UpgradeVersionService;
import com.atlassian.pocketknife.internal.logging.LoggingUtil;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.servicedesk.bootstrap.healthcheck.ServiceDeskHealth;
import com.atlassian.servicedesk.bootstrap.lifecycle.LifecycleLock;
import com.atlassian.servicedesk.bootstrap.lifecycle.SDMailChannelInitializer;
import com.atlassian.servicedesk.bootstrap.lifecycle.server.PluginInitializer;
import com.atlassian.servicedesk.bootstrap.lifecycle.server.SDEnablementMessageConsumer;
import com.atlassian.servicedesk.bootstrap.lifecycle.server.ServiceDeskReRaisedLicenseChangedEvent;
import com.atlassian.servicedesk.bootstrap.lifecycle.server.UnsatisfiedVersionRequirementException;
import com.atlassian.servicedesk.bootstrap.lifecycle.server.UpgradeRequirementsChecker;
import com.atlassian.servicedesk.bootstrap.upgrade.AsyncUpgradeTaskScheduler;
import com.atlassian.servicedesk.bootstrap.upgrade.SyncUpgradeTaskException;
import com.atlassian.servicedesk.bootstrap.upgrade.SyncUpgradeTaskService;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskApplicationLicenseService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon.RequestTypeSystemIconsCreator;
import com.atlassian.servicedesk.internal.project.type.ServiceDeskProjectCreateHandler;
import com.atlassian.servicedesk.internal.project.type.ServiceDeskProjectTypeUpdatedHandler;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerPluginLifeCycle {
    private static final Logger log = LoggerFactory.getLogger(ServerPluginLifeCycle.class);
    public static final Set<String> INVARIANT_MODULE_KEYS = ImmutableSet.of((Object)"external-customer-lockout-filter", (Object)"sd-abp-auth", (Object)"com.atlassian.servicedesk.collaborator.access");
    private final LoggingSupport loggingSupport;
    private final EventPublisher eventPublisher;
    private final ActiveObjectsController activeObjectsController;
    private final UpgradeVersionService upgradeVersionService;
    private final UpgradeRequirementsChecker upgradeRequirementsChecker;
    private final SupportInfo supportInfo;
    private final ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService;
    private final LifecycleLock lifecycleLock;
    private final ServiceDeskHealth serviceDeskHealth;
    private final PluginInitializer pluginInitializer;
    private final AsyncUpgradeTaskScheduler asyncUpgradeTaskScheduler;
    private final ProjectCreateRegistrar projectCreateRegistrar;
    private final ServiceDeskProjectCreateHandler sdProjectCreateHandler;
    private final ProjectTypeUpdatedRegistrar projectTypeUpdatedRegistrar;
    private final ServiceDeskProjectTypeUpdatedHandler sdProjectTypeUpdatedHandler;
    private final RequestTypeSystemIconsCreator requestTypeSystemIconsCreator;
    private final SDMailChannelInitializer sdMailChannelInitializer;
    private final SyncUpgradeTaskService syncUpgradeTaskService;
    private final InvariantModuleTracker invariantModuleTracker;
    private final SafeRunner safeRunner;
    private final ClusterMessagingService clusterMessagingService;
    @TenantAware(value=TenancyScope.TENANTLESS, comment="Global object, doesn't contain tenant data. Data Center specific.")
    private final LazyReference<SDEnablementMessageConsumer> sdEnablementMessageConsumer = new LazyReference<SDEnablementMessageConsumer>(){

        protected SDEnablementMessageConsumer create() throws Exception {
            return new SDEnablementMessageConsumer(ServerPluginLifeCycle.this, ServerPluginLifeCycle.this.safeRunner);
        }
    };

    @Autowired
    public ServerPluginLifeCycle(LoggingSupport loggingSupport, EventPublisher eventPublisher, ActiveObjectsController activeObjectsController, UpgradeVersionService upgradeVersionService, UpgradeRequirementsChecker upgradeRequirementsChecker, SupportInfo supportInfo, ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService, LifecycleLock lifecycleLock, ServiceDeskHealth serviceDeskHealth, PluginInitializer pluginInitializer, AsyncUpgradeTaskScheduler asyncUpgradeTaskScheduler, ProjectCreateRegistrar projectCreateRegistrar, ServiceDeskProjectCreateHandler sdProjectCreateHandler, ProjectTypeUpdatedRegistrar projectTypeUpdatedRegistrar, ServiceDeskProjectTypeUpdatedHandler sdProjectTypeUpdatedHandler, RequestTypeSystemIconsCreator requestTypeSystemIconsCreator, SDMailChannelInitializer sdMailChannelInitializer, SyncUpgradeTaskService syncUpgradeTaskService, InvariantModuleTracker invariantModuleTracker, SafeRunner safeRunner, ClusterMessagingService clusterMessagingService) {
        this.loggingSupport = loggingSupport;
        this.eventPublisher = eventPublisher;
        this.activeObjectsController = activeObjectsController;
        this.upgradeVersionService = upgradeVersionService;
        this.upgradeRequirementsChecker = upgradeRequirementsChecker;
        this.supportInfo = supportInfo;
        this.serviceDeskApplicationLicenseService = serviceDeskApplicationLicenseService;
        this.lifecycleLock = lifecycleLock;
        this.serviceDeskHealth = serviceDeskHealth;
        this.pluginInitializer = pluginInitializer;
        this.asyncUpgradeTaskScheduler = asyncUpgradeTaskScheduler;
        this.projectCreateRegistrar = projectCreateRegistrar;
        this.sdProjectCreateHandler = sdProjectCreateHandler;
        this.projectTypeUpdatedRegistrar = projectTypeUpdatedRegistrar;
        this.sdProjectTypeUpdatedHandler = sdProjectTypeUpdatedHandler;
        this.requestTypeSystemIconsCreator = requestTypeSystemIconsCreator;
        this.sdMailChannelInitializer = sdMailChannelInitializer;
        this.syncUpgradeTaskService = syncUpgradeTaskService;
        this.invariantModuleTracker = invariantModuleTracker;
        this.safeRunner = safeRunner;
        this.clusterMessagingService = clusterMessagingService;
        LoggingUtil.setLevelToInfoIfNotDefined(log);
    }

    @EventListener
    public final void onImportCompletedEvent(ImportCompletedEvent importCompletedEvent) {
        this.restartPlugin();
    }

    @EventListener
    public void handleLicenseEvent(LicenseChangedEvent event) {
        if (!this.isApplicationLicenseChangedEvent(event)) {
            return;
        }
        log.warn(String.format("A %s event has occurred.  Reacting asynchronously to this...", event.getClass().getSimpleName()));
        this.eventPublisher.publish((Object)new ServiceDeskReRaisedLicenseChangedEvent(event));
    }

    private boolean isApplicationLicenseChangedEvent(LicenseChangedEvent event) {
        io.atlassian.fugue.Option oldLicenseDetails = StepsConverters.newerOption((Option)event.getPreviousLicenseDetails());
        io.atlassian.fugue.Option newLicenseDetails = StepsConverters.newerOption((Option)event.getNewLicenseDetails());
        boolean wasServiceDeskLicensed = oldLicenseDetails.exists(this::isServiceDeskLicensed);
        boolean isServiceDeskLicensed = newLicenseDetails.exists(this::isServiceDeskLicensed);
        return wasServiceDeskLicensed || isServiceDeskLicensed;
    }

    private boolean isServiceDeskLicensed(LicenseDetails licenseDetails) {
        return licenseDetails.getLicensedApplications().getKeys().contains(ServiceDeskApplicationLicenseService.SERVICEDESK_KEY);
    }

    @EventListener
    public void handleEvent(ServiceDeskReRaisedLicenseChangedEvent event) {
        this.safeRunner.runAlways("New Licence", this::restartPlugin);
        this.clusterMessagingService.sendRemote("sd.enablement", "Check state");
    }

    public void onPluginStarted() {
        this.lifecycleLock.runOnStartup(() -> {
            this.start();
            this.eventPublisher.register((Object)this);
        });
    }

    private void start() {
        this.loggingSupport.logImportantMsg("Server Plugin LifeCycle - Starting Service Desk");
        try {
            this.serviceDeskHealth.clearHealthyState();
            boolean licenseOk = this.checkLicense();
            boolean upgradeOk = this.checkAndRunUpgrades();
            if (licenseOk && upgradeOk) {
                this.initializeLicenseDependentItems();
            }
            this.projectTypeUpdatedRegistrar.register((ProjectTypeUpdatedHandler)this.sdProjectTypeUpdatedHandler);
            this.projectCreateRegistrar.register((ProjectCreateHandler)this.sdProjectCreateHandler);
            this.loggingSupport.logImportantMsg("Finished initialisation.");
            this.supportInfo.logSupportInfoOnStartup();
            this.supportInfo.showUpgradeTaskHistory();
            this.clusterMessagingService.registerListener("sd.enablement", (ClusterMessageConsumer)this.sdEnablementMessageConsumer.get());
            if (licenseOk) {
                this.loggingSupport.logImportantMsg(this.serviceDeskApplicationLicenseService.getLicenseSummary());
                this.loggingSupport.onPluginStarted();
            } else {
                this.loggingSupport.logImportantMsg("ServiceDesk is not licenced for use.  Most modules have not been started.");
            }
        }
        catch (Throwable t) {
            this.serviceDeskHealth.setStartupNotAOK(t);
            this.showError(t, "Startup has failed with an unexpected problem. It is unsafe to proceed.");
        }
    }

    public boolean checkLicense() {
        log.info("Checking license...");
        io.atlassian.fugue.Option licenceError = this.serviceDeskApplicationLicenseService.getDescriptiveLicenseError();
        licenceError.foreach(this.loggingSupport::logImportantMsg);
        return licenceError.isEmpty();
    }

    private boolean checkAndRunUpgrades() {
        try {
            log.info("Check if upgrade requirements are satisfied...");
            this.upgradeRequirementsChecker.checkVersionRequirementForUpgrade(this.upgradeVersionService.getCurrentPluginRunInfo());
            log.info("Initialising ActiveObjects support and running AO upgrade tasks...");
            this.activeObjectsController.initialise();
            this.runSyncUpgradeTasks();
            return true;
        }
        catch (UnsatisfiedVersionRequirementException e) {
            this.serviceDeskHealth.setUpgradeVersionRequirementAOK(e);
            this.showError(e, "Version requirement for upgrade is not satisfied. It is unsafe to proceed.");
        }
        catch (ActiveObjectInitialisationException e) {
            this.serviceDeskHealth.setAoNotAOK((Exception)((Object)e));
            this.showError(e, "Unable to initialize ActiveObjects.  It is unsafe to proceed.");
        }
        catch (SyncUpgradeTaskException e) {
            this.serviceDeskHealth.setUpgradeTasksNotAOK(e);
            this.showError(e, "Unable to run SyncUpgradeTasks. It is unsafe to proceed.");
        }
        return false;
    }

    private void runSyncUpgradeTasks() throws SyncUpgradeTaskException {
        this.syncUpgradeTaskService.runAll();
    }

    private void initializeLicenseDependentItems() {
        this.initializeInvariantModules();
        this.pluginInitializer.initialize();
        this.requestTypeSystemIconsCreator.initialize();
        this.sdMailChannelInitializer.enableSDMailChannels();
        try {
            this.asyncUpgradeTaskScheduler.scheduleAsyncUpgradeTasks();
        }
        catch (SchedulerServiceException e) {
            this.serviceDeskHealth.setAsyncUpgradeScheduledNotAOK((Exception)((Object)e));
            this.showError(e, "Unable to run schedule async UpgradeTasks.  It is unsafe to proceed.");
        }
        this.upgradeVersionService.recordPluginStarted();
    }

    private void initializeInvariantModules() {
        for (String moduleKey : INVARIANT_MODULE_KEYS) {
            InvariantModuleTracker.Module m = new InvariantModuleTracker.Module("com.atlassian.servicedesk", moduleKey);
            this.invariantModuleTracker.addInvariant(m);
        }
    }

    private void showError(Throwable e, String msg) {
        this.loggingSupport.logImportantMsg(msg);
        log.error(e.getMessage(), e);
        this.loggingSupport.logImportantMsg("We are now in an indeterminable state.");
    }

    public void onPluginStopped() {
        this.lifecycleLock.runOnShutdown(() -> {
            this.eventPublisher.unregister((Object)this);
            this.stop();
        });
    }

    private void stop() {
        this.loggingSupport.logImportantMsg("Server Plugin LifeCycle - Stopping Service Desk");
        this.clusterMessagingService.unregisterListener("sd.enablement", (ClusterMessageConsumer)this.sdEnablementMessageConsumer.get());
        this.serviceDeskHealth.clearHealthyStateOnStop();
        this.sdMailChannelInitializer.disableSDMailChannels();
        this.pluginInitializer.uninitialize();
        this.projectTypeUpdatedRegistrar.unregister((ProjectTypeUpdatedHandler)this.sdProjectTypeUpdatedHandler);
        this.projectCreateRegistrar.unregister((ProjectCreateHandler)this.sdProjectCreateHandler);
        this.asyncUpgradeTaskScheduler.unscheduleAsyncUpgradeTasks();
        this.loggingSupport.onPluginStopped();
    }

    public void restartPlugin() {
        this.loggingSupport.logImportantMsg("Restarting Service Desk plugin...");
        io.atlassian.fugue.Option licenseError = this.serviceDeskApplicationLicenseService.getDescriptiveLicenseError();
        if (licenseError.isDefined()) {
            this.loggingSupport.logImportantMsg("Service Desk restart: Cannot continue, the licence has changed to invalid (" + (String)licenseError.get() + ").");
            this.lifecycleLock.runOnShutdown(this::stop);
        } else {
            this.lifecycleLock.runOnStartup(() -> {
                this.stop();
                this.start();
            });
        }
    }
}

