/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.lifecycle;

import com.atlassian.fugue.Option;
import com.atlassian.jira.mail.processor.api.channel.ChannelDefinition;
import com.atlassian.jira.mail.processor.api.channel.ChannelKey;
import com.atlassian.jira.mail.processor.api.channel.ChannelManager;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.bootstrap.lifecycle.server.ServerPluginLifeCycle;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSettingManager;
import io.atlassian.fugue.Maybe;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDMailChannelInitializer {
    private static final Logger log = LoggerFactory.getLogger(ServerPluginLifeCycle.class);
    private EmailChannelSettingManager channelSettingManager;
    private ChannelManager channelManager;

    @Autowired
    public SDMailChannelInitializer(EmailChannelSettingManager channelSettingManager, ChannelManager channelManager) {
        this.channelSettingManager = channelSettingManager;
        this.channelManager = channelManager;
    }

    public void disableSDMailChannels() {
        log.info("Disabling ServiceDesk mail channels...");
        this.updateSDMailChannels(false);
    }

    public void enableSDMailChannels() {
        log.info("Enabling ServiceDesk mail channels...");
        this.updateSDMailChannels(true);
    }

    private void updateSDMailChannels(boolean enabled) {
        List<EmailChannelSetting> emailChannelSettings = this.channelSettingManager.getEmailChannelSettings();
        emailChannelSettings.stream().map(channelSetting -> StepsConverters.newerOption((Option)this.channelManager.getMailChannelByKey(ChannelKey.from((String)channelSetting.getMailChannelKey())))).filter(Maybe::isDefined).map(Maybe::get).forEach(channelDefinition -> {
            ChannelDefinition updatedChannelDefinition = channelDefinition.getBuilderForUpdate().setEnabled(enabled).build();
            this.channelManager.update(updatedChannelDefinition);
        });
    }
}

