/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.lifecycle;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.logging.LoggingSupport;
import com.atlassian.pocketknife.api.util.runners.SealedRunner;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.servicedesk.bootstrap.lifecycle.server.ServerPluginLifeCycle;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class Launcher
implements LifecycleAware {
    private final EventPublisher eventPublisher;
    private final LoggingSupport loggingSupport;
    private final ServerPluginLifeCycle serverPluginLifeCycle;
    private LazyReference<SealedRunner> sealedStartCompleteRunner = new LazyReference<SealedRunner>(){

        protected SealedRunner create() throws Exception {
            return new SealedRunner((List)Lists.newArrayList((Object[])new String[]{Launcher.PLUGIN_STARTED_EVENT, Launcher.LIFECYCLE_AWARE_ONSTART}), new Runnable(){

                @Override
                public void run() {
                    Launcher.this.onStartCompleted();
                }
            });
        }
    };
    private static final String PLUGIN_STARTED_EVENT = "plugin.started.event";
    private static final String LIFECYCLE_AWARE_ONSTART = "lifecycle.aware.onstart";

    @Autowired
    public Launcher(EventPublisher eventPublisher, LoggingSupport loggingSupport, ServerPluginLifeCycle serverPluginLifeCycle) {
        this.eventPublisher = eventPublisher;
        this.loggingSupport = loggingSupport;
        this.serverPluginLifeCycle = serverPluginLifeCycle;
    }

    @PostConstruct
    public void onSpringContextStarted() {
        this.eventPublisher.register((Object)this);
        this.loggingSupport.onPluginStarting();
    }

    @EventListener
    public final void onPluginStarted(PluginEnabledEvent pluginEnabledEvent) {
        if (pluginEnabledEvent.getPlugin().getKey().equals("com.atlassian.servicedesk")) {
            ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(PLUGIN_STARTED_EVENT);
        }
    }

    public void onStart() {
        ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(LIFECYCLE_AWARE_ONSTART);
    }

    private void onStartCompleted() {
        this.serverPluginLifeCycle.onPluginStarted();
    }

    public void onStop() {
        this.loggingSupport.onPluginStopping();
        this.eventPublisher.unregister((Object)this);
        this.serverPluginLifeCycle.onPluginStopped();
    }

    public void restartPlugin() {
        this.serverPluginLifeCycle.restartPlugin();
    }
}

