/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.logging;

import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingUtil {
    private static final Logger log = LoggerFactory.getLogger(LoggingUtil.class);

    public static void setLoggingLevel(Logger slf4jLogger, String desiredLevel) {
        LoggingUtil.setLoggingLevel(slf4jLogger, desiredLevel, true);
    }

    public static void setLevelToInfoIfNotDefined(Logger slf4jLogger) {
        LoggingUtil.setLoggingLevel(slf4jLogger.getName(), Level.INFO, false);
    }

    public static void setLoggingLevel(Logger slf4jLogger, String desiredLevel, boolean overwrite) {
        LoggingUtil.setLoggingLevel(slf4jLogger.getName(), LoggingUtil.translateToLog4jLevel(desiredLevel), overwrite);
    }

    public static void setLoggingLevel(Logger slf4jLogger, Level desiredLevel, boolean overwrite) {
        LoggingUtil.setLoggingLevel(slf4jLogger.getName(), desiredLevel, overwrite);
    }

    private static void setLoggingLevel(String loggerName, Level desiredLevel, boolean overwrite) {
        block7: {
            try {
                org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger((String)loggerName);
                if (log4jLogger != null) {
                    if (log4jLogger.getLevel() == null || overwrite) {
                        log4jLogger.setLevel(desiredLevel);
                    } else if (log4jLogger.getLevel() != desiredLevel) {
                        log.warn("logger: {} is pre-configured with level:{}", (Object)loggerName, (Object)log4jLogger.getLevel());
                    }
                } else {
                    log.warn("No such logger: {}", (Object)loggerName);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block7;
                log.error("Can't setLoggingLevel for some reason...", (Throwable)e);
            }
        }
    }

    public static Level translateToLog4jLevel(String levelName) {
        return Level.toLevel((String)levelName);
    }
}

