/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.logging;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.log.LoggingConfiguration;
import com.atlassian.pocketknife.api.logging.LoggingSupport;
import com.atlassian.pocketknife.spi.logging.PocketKnifeLoggingInfo;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoggingSupportImpl
implements LoggingSupport {
    private final JiraHome jiraHome;
    private final PocketKnifeLoggingInfo pocketKnifeLoggingInfo;
    private final LoggingConfiguration loggingConfiguration;

    @Autowired
    public LoggingSupportImpl(JiraHome jiraHome, PocketKnifeLoggingInfo pocketKnifeLoggingInfo, LoggingConfiguration loggingConfiguration) {
        this.jiraHome = jiraHome;
        this.pocketKnifeLoggingInfo = pocketKnifeLoggingInfo;
        this.loggingConfiguration = loggingConfiguration;
    }

    @Override
    public void onPluginStarting() {
        this.createAppenders();
        this.logPluginMessage("plugin starting...");
    }

    @Override
    public void logImportantMsg(String msg) {
        this.logPluginMessage(msg);
    }

    @Override
    public void onPluginStarted() {
        this.logPluginMessage(String.format("started. %s", this.pocketKnifeLoggingInfo.getPithyStartUpMsg()));
    }

    @Override
    public void onPluginStopping() {
        this.logPluginMessage("stopping...");
    }

    @Override
    public void onPluginStopped() {
        this.logPluginMessage("stopped");
    }

    @Override
    public Logger log() {
        org.apache.log4j.Logger log = this.getLogger();
        return LoggerFactory.getLogger((String)log.getName());
    }

    private org.apache.log4j.Logger getLogger() {
        org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger((String)this.pocketKnifeLoggingInfo.getStartupLoggerName());
        log.setLevel(Level.INFO);
        return log;
    }

    private void createAppenders() {
        Appender ourAppender = null;
        for (String loggerName : this.pocketKnifeLoggingInfo.getLoggerNamespace()) {
            org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)loggerName);
            if (logger.getAppender(this.getProductLogName()) != null) continue;
            ourAppender = ourAppender == null ? this.createOurAppender() : ourAppender;
            logger.addAppender(ourAppender);
        }
    }

    private String getProductLogName() {
        return this.pocketKnifeLoggingInfo.getProductLogName();
    }

    private Appender createOurAppender() {
        try {
            PatternLayout layout = this.loggingConfiguration.getSystemPatternLayout();
            String logFileName = this.getProductLogName() + ".log";
            String fileName = new File(this.jiraHome.getLogDirectory(), logFileName).getAbsolutePath();
            RollingFileAppender appender = new RollingFileAppender((Layout)layout, fileName, true);
            appender.setName(this.getProductLogName());
            appender.setMaxFileSize("20480KB");
            appender.setMaxBackupIndex(5);
            return appender;
        }
        catch (IOException ioe) {
            IllegalStateException illegalStateException = new IllegalStateException("Unable to initialise log4j support", ioe);
            this.log().error(illegalStateException.getMessage());
            throw illegalStateException;
        }
    }

    private void logPluginMessage(String msg) {
        org.apache.log4j.Logger log = this.getLogger();
        log.info((Object)msg);
    }
}

