/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.jql;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.pocketknife.api.jql.JqlValidation;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JqlValidationImpl
implements JqlValidation {
    @Autowired
    private SearchService searchService;
    @Autowired
    private JqlQueryParser jqlQueryParser;

    @Override
    public List<String> validateJql(ApplicationUser user, String queryString) {
        ArrayList<String> errors = new ArrayList<String>();
        Query query = this.createQuery(user, queryString, errors);
        if (query != null) {
            MessageSet result = this.searchService.validateQuery(user, query);
            errors.addAll(result.getErrorMessages());
            errors.addAll(result.getWarningMessages());
        }
        return errors;
    }

    private Query createQuery(ApplicationUser user, String jqlQuery, List<String> errors) {
        Query newQuery = null;
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jqlQuery);
        if (parseResult.isValid()) {
            newQuery = parseResult.getQuery();
        } else {
            errors.addAll(parseResult.getErrors().getErrorMessages());
        }
        return newQuery;
    }
}

