/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.customfields.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ActualValueEqualityQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.pocketknife.internal.customfields.query.JSDOperatorSpecificQueryFactory;
import com.atlassian.pocketknife.internal.customfields.query.JSDQueryFactoryResult;
import com.atlassian.pocketknife.internal.customfields.query.JSDTermQueryFactory;
import com.atlassian.pocketknife.internal.customfields.util.IndexValuesConverter;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSDValueEqualityQueryFactory
implements JSDOperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(ActualValueEqualityQueryFactory.class);
    private final IndexValuesConverter indexValuesConverter;
    private final String emptyIndexValue;

    public JSDValueEqualityQueryFactory(IndexValuesConverter indexValuesConverter, String emptyIndexValue) {
        this.indexValuesConverter = indexValuesConverter;
        this.emptyIndexValue = (String)Assertions.notNull((String)"emptyIndexValue", (Object)emptyIndexValue);
    }

    public JSDValueEqualityQueryFactory(IndexValuesConverter indexValuesConverter) {
        this.indexValuesConverter = indexValuesConverter;
        this.emptyIndexValue = null;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(QueryCreationContext queryCreationContext, String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.EQUALS && operator != Operator.NOT_EQUALS) {
            log.debug(String.format("Creating an equality query for a single value for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", fieldName, operator, Operator.EQUALS, Operator.NOT_EQUALS));
            return QueryFactoryResult.createFalseResult();
        }
        return this.createResult(queryCreationContext, fieldName, operator, rawValues);
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(QueryCreationContext queryCreationContext, String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            return this.createResult(queryCreationContext, fieldName, operator, rawValues);
        }
        log.debug(String.format("Creating an equality query for multiple values for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", fieldName, operator, Operator.IN, Operator.NOT_IN));
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(QueryCreationContext queryCreationContext, String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return new QueryFactoryResult(this.getIsEmptyQuery(fieldName));
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        log.debug(String.format("Creating an equality query for an empty value for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s','%s', '%s' and '%s'", fieldName, operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS));
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    private QueryFactoryResult createResult(QueryCreationContext queryCreationContext, String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.EQUALS) {
            return this.handleIn(fieldName, this.indexValuesConverter.getIndexValues(queryCreationContext, rawValues));
        }
        if (operator == Operator.NOT_IN || operator == Operator.NOT_EQUALS) {
            return this.handleNotIn(fieldName, this.indexValuesConverter.getIndexValues(queryCreationContext, rawValues));
        }
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult handleIn(String fieldName, List<String> values2) {
        if (values2.size() == 1) {
            String value = values2.get(0);
            Query query = value == null ? this.getIsEmptyQuery(fieldName) : this.getTermQuery(fieldName, value);
            return new QueryFactoryResult(query);
        }
        BooleanQuery combined = new BooleanQuery();
        for (String value : values2) {
            if (value == null) {
                combined.add(this.getIsEmptyQuery(fieldName), BooleanClause.Occur.SHOULD);
                continue;
            }
            combined.add((Query)this.getTermQuery(fieldName, value), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)combined);
    }

    private QueryFactoryResult handleNotIn(String fieldName, List<String> values2) {
        ArrayList notQueries = Lists.newArrayListWithCapacity((int)values2.size());
        for (String indexValue : values2) {
            if (indexValue == null) continue;
            notQueries.add(this.getTermQuery(fieldName, indexValue));
        }
        if (notQueries.isEmpty()) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        BooleanQuery boolQuery = new BooleanQuery();
        boolQuery.add(this.getIsNotEmptyQuery(fieldName), BooleanClause.Occur.MUST);
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
        }
        boolQuery.add(JSDTermQueryFactory.visibilityQuery(fieldName), BooleanClause.Occur.MUST);
        return new QueryFactoryResult((Query)boolQuery, false);
    }

    private Query getIsEmptyQuery(String fieldName) {
        if (this.emptyIndexValue != null) {
            return this.getTermQuery(fieldName, this.emptyIndexValue);
        }
        JSDQueryFactoryResult result = new JSDQueryFactoryResult(JSDTermQueryFactory.nonEmptyQuery(fieldName), true);
        return JSDQueryFactoryResult.wrapWithVisibilityQuery(fieldName, result).getLuceneQuery();
    }

    private Query getIsNotEmptyQuery(String fieldName) {
        if (this.emptyIndexValue != null) {
            JSDQueryFactoryResult result = new JSDQueryFactoryResult((Query)this.getTermQuery(fieldName, this.emptyIndexValue), true);
            return JSDQueryFactoryResult.wrapWithVisibilityQuery(fieldName, result).getLuceneQuery();
        }
        return JSDTermQueryFactory.nonEmptyQuery(fieldName);
    }

    private TermQuery getTermQuery(String fieldName, String value) {
        return new TermQuery(new Term(fieldName, value));
    }
}

