/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.customfields.query;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;

public class JSDRangeQueryFactory<T> {
    private final Function<T, String> valueFactory;

    static JSDRangeQueryFactory<String> stringRangeQueryFactory() {
        return new JSDRangeQueryFactory<String>(Functions.identity());
    }

    public JSDRangeQueryFactory(Function<T, String> valueFactory) {
        this.valueFactory = (Function)Assertions.notNull((String)"valueFactory", valueFactory);
    }

    Query get(Operator operator, String fieldName, T value) {
        switch (operator) {
            case LESS_THAN: {
                return this.handleLessThan(fieldName, value);
            }
            case LESS_THAN_EQUALS: {
                return this.handleLessThanEquals(fieldName, value);
            }
            case GREATER_THAN: {
                return this.handleGreaterThan(fieldName, value);
            }
            case GREATER_THAN_EQUALS: {
                return this.handleGreaterThanEquals(fieldName, value);
            }
        }
        throw new IllegalArgumentException("Unhandled Operator: " + operator);
    }

    Query get(Operator operator, String fieldName, List<T> values2) {
        if (operator == Operator.DURING) {
            if (values2.get(0) == null) {
                return this.handleLessThanEquals(fieldName, values2.get(1));
            }
            if (values2.get(1) == null) {
                return this.handleGreaterThanEquals(fieldName, values2.get(0));
            }
            return this.handleDuring(fieldName, values2.get(0), values2.get(1));
        }
        throw new IllegalArgumentException("Unhandled Operator: " + operator);
    }

    Query handleLessThan(String fieldName, T value) {
        return new TermRangeQuery(fieldName, null, (String)this.valueFactory.get(value), true, false);
    }

    Query handleLessThanEquals(String fieldName, T value) {
        return new TermRangeQuery(fieldName, null, (String)this.valueFactory.get(value), true, true);
    }

    Query handleGreaterThan(String fieldName, T value) {
        return new TermRangeQuery(fieldName, (String)this.valueFactory.get(value), null, false, true);
    }

    Query handleGreaterThanEquals(String fieldName, T value) {
        return new TermRangeQuery(fieldName, (String)this.valueFactory.get(value), null, true, true);
    }

    Query handleDuring(String fieldName, T lowerValue, T upperValue) {
        return new TermRangeQuery(fieldName, (String)this.valueFactory.get(lowerValue), (String)this.valueFactory.get(upperValue), true, true);
    }
}

