/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.customfields.query;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.pocketknife.internal.customfields.query.JSDTermQueryFactory;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public final class JSDQueryFactoryResult {
    private static final JSDQueryFactoryResult FALSE_RESULT = new JSDQueryFactoryResult((Query)new BooleanQuery(), false);
    private final Query luceneQuery;
    private final boolean mustNotOccur;

    public static JSDQueryFactoryResult createFalseResult() {
        return FALSE_RESULT;
    }

    static JSDQueryFactoryResult wrapWithVisibilityQuery(String fieldName, JSDQueryFactoryResult result) {
        if (FALSE_RESULT.equals(result)) {
            return result;
        }
        BooleanQuery finalQuery = new BooleanQuery();
        JSDQueryFactoryResult.addToBooleanWithMust(result, finalQuery);
        finalQuery.add(JSDTermQueryFactory.visibilityQuery(fieldName), BooleanClause.Occur.MUST);
        return new JSDQueryFactoryResult((Query)finalQuery);
    }

    public static JSDQueryFactoryResult mergeResultsWithShould(List<JSDQueryFactoryResult> results) {
        Assertions.containsNoNulls((String)"results", results);
        BooleanQuery finalQuery = new BooleanQuery();
        for (JSDQueryFactoryResult result : results) {
            if (FALSE_RESULT.equals(result)) continue;
            JSDQueryFactoryResult.addToBooleanWithShould(result, finalQuery);
        }
        return new JSDQueryFactoryResult((Query)finalQuery);
    }

    private static void addToBooleanWithMust(JSDQueryFactoryResult result, BooleanQuery booleanQuery) {
        JSDQueryFactoryResult.addToBooleanWithOccur(result, booleanQuery, BooleanClause.Occur.MUST);
    }

    private static void addToBooleanWithShould(JSDQueryFactoryResult result, BooleanQuery booleanQuery) {
        JSDQueryFactoryResult.addToBooleanWithOccur(result, booleanQuery, BooleanClause.Occur.SHOULD);
    }

    private static void addToBooleanWithOccur(JSDQueryFactoryResult result, BooleanQuery booleanQuery, BooleanClause.Occur occur) {
        if (result.mustNotOccur()) {
            booleanQuery.add(result.getLuceneQuery(), BooleanClause.Occur.MUST_NOT);
        } else {
            booleanQuery.add(result.getLuceneQuery(), occur);
        }
    }

    public JSDQueryFactoryResult(Query luceneQuery) {
        this(luceneQuery, false);
    }

    public JSDQueryFactoryResult(Query luceneQuery, boolean mustNotOccur) {
        this.luceneQuery = (Query)Assertions.notNull((String)"luceneQuery", (Object)luceneQuery);
        this.mustNotOccur = mustNotOccur;
    }

    public Query getLuceneQuery() {
        return this.luceneQuery;
    }

    public boolean mustNotOccur() {
        return this.mustNotOccur;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSDQueryFactoryResult that = (JSDQueryFactoryResult)o;
        if (this.mustNotOccur != that.mustNotOccur) {
            return false;
        }
        return this.luceneQuery.equals((Object)that.luceneQuery);
    }

    public int hashCode() {
        int result = this.luceneQuery.hashCode();
        result = 31 * result + (this.mustNotOccur ? 1 : 0);
        return result;
    }

    public String toString() {
        return "JSDQueryFactoryResult{luceneQuery=" + this.luceneQuery + ", mustNotOccur=" + this.mustNotOccur + '}';
    }
}

