/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.web;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.soy.renderer.SoyException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SoyWebPanel
implements WebPanel {
    private final Log log = Log.with(this.getClass());
    public static final String ISSUE_KEY = "issue";
    public static final String PROJECT_KEY = "project";
    public static final String USER_KEY = "user";
    public static final String HELPER_KEY = "helper";
    private final String pluginModuleKey;
    private final String templateName;
    @Autowired
    private SoyTemplateRenderer soyTemplateRenderer;

    public SoyWebPanel(String pluginModuleKey, String templateName) {
        this.pluginModuleKey = pluginModuleKey;
        this.templateName = templateName;
    }

    public String getHtml(Map<String, Object> context) {
        StringWriter writer = new StringWriter();
        try {
            this.writeHtml(writer, context);
        }
        catch (IOException e) {
            this.log.error("Error generating SLA web panel - %s", new Object[]{e.getMessage()});
        }
        return writer.toString();
    }

    public void writeHtml(Writer writer, Map<String, Object> context) throws IOException {
        try {
            this.soyTemplateRenderer.render((Appendable)writer, this.pluginModuleKey, this.templateName, this.getTemplateParameters(context));
        }
        catch (SoyException e) {
            throw new IOException(e);
        }
    }

    protected Issue getIssue(Map<String, Object> context) {
        return (Issue)context.get(ISSUE_KEY);
    }

    protected Project getProject(Map<String, Object> context) {
        return (Project)context.get(PROJECT_KEY);
    }

    protected ApplicationUser getUser(Map<String, Object> context) {
        return (ApplicationUser)context.get(USER_KEY);
    }

    protected JiraHelper getJiraHelper(Map<String, Object> context) {
        return (JiraHelper)context.get(HELPER_KEY);
    }

    protected abstract Map<String, Object> getTemplateParameters(Map<String, Object> var1);
}

