/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.customfields.validator;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlTimetrackingDurationSupport;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.List;

public class PositiveDurationValueValidator {
    private final JqlOperandResolver operandResolver;
    private final JqlTimetrackingDurationSupport jqlTimetrackingDurationSupport;

    public PositiveDurationValueValidator(JqlOperandResolver operandResolver, JqlTimetrackingDurationSupport durationSupport) {
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.jqlTimetrackingDurationSupport = (JqlTimetrackingDurationSupport)Assertions.notNull((String)"durationSupport", (Object)durationSupport);
    }

    public MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        Assertions.notNull((String)"terminalClause", (Object)terminalClause);
        Operand operand = terminalClause.getOperand();
        MessageSetImpl messages = new MessageSetImpl();
        if (this.operandResolver.isValidOperand(operand)) {
            I18nHelper i18n = this.getI18n(searcher);
            List values2 = this.operandResolver.getValues(searcher, operand, terminalClause);
            String fieldName = terminalClause.getName();
            for (QueryLiteral value : values2) {
                boolean isValid = true;
                Long longValue = value.getLongValue();
                if (longValue != null) {
                    isValid = longValue >= 0L;
                } else {
                    String str = value.getStringValue();
                    if (str != null) {
                        isValid = this.jqlTimetrackingDurationSupport.validate(str);
                    }
                }
                if (isValid) continue;
                String msg = this.operandResolver.isFunctionOperand(value.getSourceOperand()) ? i18n.getText("jira.jql.clause.positive.duration.format.invalid.from.func", value.getSourceOperand().getName(), fieldName) : i18n.getText("jira.jql.clause.positive.duration.format.invalid", value.toString(), fieldName);
                messages.addErrorMessage(msg);
            }
        }
        return messages;
    }

    I18nHelper getI18n(ApplicationUser user) {
        return new I18nBean(user);
    }
}

