/* globals AJS, underscore */
define("JEP/shared/Tracker", [
    "underscore"
], function (
    _
) {

    var shouldDebugLog = false; // Set this to true for development debugging only

    var tracker = {};

    // Init Atlassian Analytics
    AJS.EventQueue = AJS.EventQueue || [];

    /**
     * Track a "page view", which we use for just about every user interaction.
     *
     * @param page URL-style relative path used for tracking (e.g. "/customerview/comment")
     * @param data (optional) Key-value object with additional properties for storing in analytics
     */
    tracker.trackPageview = function (page, data) {
        if (shouldDebugLog) {
            AJS.log("Tracking page view: " + page, data);
        }
        var newPage = page.replace(/^\/?/, "").replace(/\//g, ".");
        this.trackEvent("page.view", newPage, data);
    };

    /**
     * Track a non-page view event. For consistency's sake, you should use {@link trackPageview()}
     *
     * @param noun
     * @param verb
     * @param data
     */
    tracker.trackEvent = function (noun, verb, data) {
        if (shouldDebugLog) {
            AJS.log("TrackEvent: " + noun + " " + verb, data);
        }
        var name = ["jep", noun, verb].join(".");
        var props = {};
        // Ensure correct data shape (key-value pairs)
        if (data !== undefined) {
            if (!_.isObject(data) || _.isArray(data)) {
                var warning = "A tracking call was made with invalid properties. Data should be key-value pairs." +
                    " Event name is '" + name + "' and data is: ";
                AJS.warn(warning, data);
            } else {
                _.extend(props, data);
            }
        }

        var obj = {
            name: name,
            properties: props
        };
        AJS.EventQueue.push(obj);
    };

    return tracker;

});