/* global define */

/**
 * Show mail item audit (processing activity) log
 *    var mailLog = MailProcessingLog.create({
 *           el : ".jep-mail-process-log",
 *           channelKey : "CHANNEL",  // REQUIRED
 *           pageLimit : 50,          // optional
 *           currentPage : 1          // optional
 *       });
 *    mailLog.show();
 *
 * Note:
 *  - channelKey is the mail channel key from JIRA email processing plugin.
 *  - For this processing log, channelKey is required.
 */

define("JEP/MailProcessingLog", [
    "jquery",
    "underscore",
    "exports",
    "JEP/shared/Tracker",
    "JEP/MailLog",
    "JEP/MailProcessingLogModel"
], function (
    $,
    _,
    Exports,
    Tracker,
    MailLog,
    ProcessingLogModel
) {

    var View = MailLog.extend({

        template: JEP.Templates.Components.MailLog.processingLog,

        initialize: function (options) {

            // call super.initialize()
            MailLog.prototype.initialize.call(this, options);

            // initialize processing log model
            this.processingLogModel = new ProcessingLogModel();

            this.listenTo(this.processingLogModel, this.processingLogModel.events.getProcessingLogDone,
                _.bind(this._renderView, this));

            this.listenTo(this.processingLogModel, this.processingLogModel.events.getProcessingLogFailed,
                _.bind(function (errorMessage) {
                    Tracker.trackPageview("/component/maillog/processing/error", {
                        "errorMessage" : errorMessage
                    });
                    this._renderError(errorMessage);
                }, this));
        },

        show: function () {
            if (!this.hasShownBefore) {
                this.showWaitingPage();
            }
            this.hasShownBefore = true;

            if (this.channelKey) {
                Tracker.trackPageview("/component/maillog/processing/channel", {
                    "currentPage" : this.currentPage,
                    "totalPages" : this.processingLogModel.get("totalPages"),
                    "pageLimit" : this.pageLimit
                });
                this.processingLogModel.getProcessingLogForChannel(this.channelKey, this.pageLimit, this.currentPage);
            } else {
                Tracker.trackPageview("/component/maillog/processing/global", {
                    "currentPage" : this.currentPage,
                    "totalPages" : this.processingLogModel.get("totalPages"),
                    "pageLimit" : this.pageLimit
                });
                this._renderError(AJS.I18n.getText("jep.error.process.log.specify.channel.key"));
            }

            return this;
        },

        _renderView: function () {
            var jsonModel = this.processingLogModel.toJSON();
            this.$el.html(this.template({
                processingLog: jsonModel.data
            }));

            this._renderPagination(this.currentPage, jsonModel.totalPages);
            this.trigger(this.events.renderCompleted, false);
        }
    });

    Exports.create = function (options) {
        return new View(options);
    };
});